/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.Table;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.ui.eclipse.dashboard.propertypages.TableColumnSelectionDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class DCISummaryTableColumnSelector
extends AbstractSelector {
    private String emptySelectionName = "";
    private String columnName = null;
    private DciSummaryTable sourceSummaryTable;
    private Table sourceTable;

    public DCISummaryTableColumnSelector(Composite parent, int style, int options, String columnName, Table sourceTable, DciSummaryTable sourceSummaryTable) {
        super(parent, style, options == 8 ? options : 0);
        this.columnName = columnName;
        this.setText(columnName == null ? this.emptySelectionName : columnName);
        this.sourceTable = sourceTable;
        this.sourceSummaryTable = sourceSummaryTable;
    }

    protected void selectionButtonHandler() {
        TableColumnSelectionDialog dlg;
        String[] valuesArray = null;
        if (this.sourceTable != null) {
            valuesArray = this.sourceTable.getColumnDisplayNames();
        }
        if (this.sourceSummaryTable != null) {
            List column = this.sourceSummaryTable.getColumns();
            ArrayList<String> tmp = new ArrayList<String>();
            int i = 0;
            while (i < column.size()) {
                tmp.add(((DciSummaryTableColumn)column.get(i)).getName());
                ++i;
            }
            valuesArray = tmp.toArray(new String[tmp.size()]);
        }
        if ((dlg = new TableColumnSelectionDialog(this.getShell(), valuesArray)).open() == 0) {
            this.columnName = dlg.getSelectedName();
            this.setText(this.columnName == null ? this.emptySelectionName : this.columnName);
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.columnName = null;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setSummaryTbale(DciSummaryTable sourceSummaryTable) {
        this.sourceSummaryTable = sourceSummaryTable;
    }
}

