/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;
import org.netxms.client.constants.Severity;

public enum WebServiceAuthType {
    NONE(0),
    BASIC(1),
    DIGEST(2),
    NTLM(3),
    BEARER(4),
    ANY(5),
    ANYSAFE(6);

    private int value;
    private static Map<Integer, WebServiceAuthType> lookupTable;

    private WebServiceAuthType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static WebServiceAuthType getByValue(int value) {
        WebServiceAuthType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(Severity.class.getName(), "Unknown element " + value);
            return NONE;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, WebServiceAuthType>();
        for (WebServiceAuthType element : WebServiceAuthType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

