/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.netxms.client.TimePeriod;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphSettingsChangeListener;
import org.netxms.client.xml.XMLTools;
import org.netxms.client.xml.XmlDateConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Convert;

@Root(name="chart", strict=false)
public class ChartConfig {
    @ElementArray(required=true)
    protected ChartDciConfig[] dciList = new ChartDciConfig[0];
    @Element(required=false)
    protected String title = "";
    @Element(required=false)
    protected int legendPosition = 8;
    @Element(required=false)
    protected boolean showLegend = true;
    @Element(required=false)
    protected boolean extendedLegend = true;
    @Element(required=false)
    protected boolean showTitle = false;
    @Element(required=false)
    protected boolean showGrid = true;
    @Element(required=false)
    protected boolean showHostNames = false;
    @Element(required=false)
    protected boolean autoRefresh = true;
    @Element(required=false)
    protected boolean logScale = false;
    @Element(required=false)
    protected boolean stacked = false;
    @Element(required=false)
    protected boolean translucent = true;
    @Element(required=false)
    protected boolean area = false;
    @Element(required=false)
    protected int lineWidth = 2;
    @Element(required=false)
    protected boolean autoScale = true;
    @Element(required=false)
    protected double minYScaleValue = 0.0;
    @Element(required=false)
    protected double maxYScaleValue = 100.0;
    @Element(required=false)
    protected int refreshRate = 30;
    @Element(required=false)
    protected int timeUnits = 1;
    @Element(required=false)
    protected int timeRange = 1;
    @Element(required=false)
    protected int timeFrameType = 1;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    protected Date timeFrom;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    protected Date timeTo;
    @Element(required=false)
    private boolean modifyYBase = false;
    @Element(required=false)
    private boolean useMultipliers = true;
    private Set<GraphSettingsChangeListener> changeListeners = new HashSet<GraphSettingsChangeListener>(0);

    public static ChartConfig createFromXml(String xml) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (ChartConfig)((Object)serializer.read(ChartConfig.class, xml));
    }

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public long getTimeRangeMillis() {
        switch (this.timeUnits) {
            case 0: {
                return (long)this.timeRange * 60L * 1000L;
            }
            case 1: {
                return (long)this.timeRange * 60L * 60L * 1000L;
            }
            case 2: {
                return (long)this.timeRange * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChartDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(ChartDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.timeRange = timeRange;
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public void setShowHostNames(boolean showHostNames) {
        this.showHostNames = showHostNames;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public int getTimeFrameType() {
        return this.timeFrameType;
    }

    public void setTimeFrameType(int timeFrameType) {
        this.timeFrameType = timeFrameType;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    public boolean isExtendedLegend() {
        return this.extendedLegend;
    }

    public void setExtendedLegend(boolean extendedLegend) {
        this.extendedLegend = extendedLegend;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isArea() {
        return this.area;
    }

    public void setArea(boolean area) {
        this.area = area;
    }

    public double getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(double minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public double getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(double maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public TimePeriod timePeriod() {
        return new TimePeriod(this.timeFrameType, this.timeRange, this.timeUnits, this.timeFrom, this.timeTo);
    }

    public void setTimePeriod(TimePeriod tp) {
        this.timeFrameType = tp.getTimeFrameType();
        this.timeRange = tp.getTimeRangeValue();
        this.timeUnits = tp.getTimeUnitValue();
        this.timeFrom = tp.getTimeFromValue();
        this.timeTo = tp.getTimeToValue();
    }

    public void addChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (GraphSettingsChangeListener l : this.changeListeners) {
            l.onGraphSettingsChange(this);
        }
    }

    public void setModifyYBase(boolean modifyYBase) {
        this.modifyYBase = modifyYBase;
    }

    public boolean modifyYBase() {
        return this.modifyYBase;
    }

    public void setConfig(ChartConfig config2) {
        this.dciList = (ChartDciConfig[])config2.dciList.clone();
        this.title = config2.title;
        this.legendPosition = config2.legendPosition;
        this.showLegend = config2.showLegend;
        this.extendedLegend = config2.extendedLegend;
        this.showTitle = config2.showTitle;
        this.showGrid = config2.showGrid;
        this.showHostNames = config2.showHostNames;
        this.autoRefresh = config2.autoRefresh;
        this.logScale = config2.logScale;
        this.stacked = config2.stacked;
        this.translucent = config2.translucent;
        this.area = config2.area;
        this.lineWidth = config2.lineWidth;
        this.autoScale = config2.autoScale;
        this.minYScaleValue = config2.minYScaleValue;
        this.maxYScaleValue = config2.maxYScaleValue;
        this.refreshRate = config2.refreshRate;
        this.timeUnits = config2.timeUnits;
        this.timeRange = config2.timeRange;
        this.timeFrameType = config2.timeFrameType;
        this.timeFrom = config2.timeFrom;
        this.timeTo = config2.timeTo;
        this.modifyYBase = config2.modifyYBase;
        this.useMultipliers = config2.useMultipliers;
    }

    public boolean isUseMultipliers() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }
}

