/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;

public class WirelessStation {
    private MacAddress macAddress;
    private InetAddress ipAddress;
    private long nodeObjectId;
    private long accessPointId;
    private String radioInterface;
    private String ssid;
    private int vlan;

    public WirelessStation(NXCPMessage msg, long baseId) {
        this.macAddress = new MacAddress(msg.getFieldAsBinary(baseId));
        this.ipAddress = msg.getFieldAsInetAddress(baseId + 1L);
        this.ssid = msg.getFieldAsString(baseId + 2L);
        this.vlan = msg.getFieldAsInt32(baseId + 3L);
        this.accessPointId = msg.getFieldAsInt64(baseId + 4L);
        this.radioInterface = msg.getFieldAsString(baseId + 6L);
        this.nodeObjectId = msg.getFieldAsInt64(baseId + 7L);
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public long getNodeObjectId() {
        return this.nodeObjectId;
    }

    public long getAccessPointId() {
        return this.accessPointId;
    }

    public String getRadioInterface() {
        return this.radioInterface;
    }

    public String getSsid() {
        return this.ssid;
    }

    public int getVlan() {
        return this.vlan;
    }
}

