/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

public class NXCPException
extends Exception {
    public static final int MESSAGE_TOO_LARGE = 1;
    public static final int SESSION_CLOSED = 2;
    public static final int NO_CIPHER = 3;
    public static final int DECRYPTION_ERROR = 4;
    private static final long serialVersionUID = -1220864361254471L;
    private static final String[] errorText = new String[]{"", "Message is too large", "Underlying communication session closed", "No cipher", "Decryption error"};
    private int errorCode;

    public NXCPException(int errorCode) {
        this.errorCode = errorCode;
    }

    public NXCPException(int errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        try {
            return "NXCP error: " + errorText[this.errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "NXCP error " + Integer.toString(this.errorCode);
        }
    }
}

