/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.base.NXCPMessage;

public class SnmpUsmCredential {
    private String name;
    private int authMethod;
    private int privMethod;
    private String authPassword;
    private String privPassword;
    private int zoneId;
    private String comment;

    public SnmpUsmCredential(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.authMethod = msg.getFieldAsInt32(baseId + 1L);
        this.privMethod = msg.getFieldAsInt32(baseId + 2L);
        this.authPassword = msg.getFieldAsString(baseId + 3L);
        this.privPassword = msg.getFieldAsString(baseId + 4L);
        this.zoneId = msg.getFieldAsInt32(baseId + 5L);
        this.comment = msg.getFieldAsString(baseId + 6L);
    }

    public SnmpUsmCredential() {
        this.name = "";
        this.authMethod = 0;
        this.privMethod = 0;
        this.authPassword = "";
        this.privPassword = "";
        this.zoneId = 0;
        this.comment = "";
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setFieldInt16(baseId + 1L, this.authMethod);
        msg.setFieldInt16(baseId + 2L, this.privMethod);
        msg.setField(baseId + 3L, this.authPassword);
        msg.setField(baseId + 4L, this.privPassword);
        msg.setField(baseId + 5L, this.comment);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getPrivMethod() {
        return this.privMethod;
    }

    public void setPrivMethod(int privMethod) {
        this.privMethod = privMethod;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getPrivPassword() {
        return this.privPassword;
    }

    public void setPrivPassword(String privPassword) {
        this.privPassword = privPassword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.authMethod;
        result = 31 * result + (this.authPassword == null ? 0 : this.authPassword.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.privMethod;
        result = 31 * result + (this.privPassword == null ? 0 : this.privPassword.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnmpUsmCredential other = (SnmpUsmCredential)obj;
        if (this.authMethod != other.authMethod) {
            return false;
        }
        if (this.authPassword == null ? other.authPassword != null : !this.authPassword.equals(other.authPassword)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privMethod != other.privMethod) {
            return false;
        }
        return !(this.privPassword == null ? other.privPassword != null : !this.privPassword.equals(other.privPassword));
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

