/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.dao.impl;

import com.radensolutions.reporting.dao.ReportResultDAO;
import com.radensolutions.reporting.model.ReportResult;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ReportResultDAOImpl
implements ReportResultDAO {
    public static final Logger logger = LoggerFactory.getLogger(ReportResultDAOImpl.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Override
    public void saveResult(ReportResult result) {
        this.sessionFactory.getCurrentSession().save((Object)result);
    }

    @Override
    public List<ReportResult> listResults(UUID reportId, int userId) {
        String strQuery = "from ReportResult result where result.reportId = :reportId and userId = :userId order by executionTime desc";
        Query query = this.sessionFactory.getCurrentSession().createQuery(strQuery).setParameter("reportId", (Object)reportId).setParameter("userId", (Object)userId);
        return Collections.checkedList(query.list(), ReportResult.class);
    }

    @Override
    public void deleteJob(UUID jobId) {
        Session session = this.sessionFactory.getCurrentSession();
        List<ReportResult> list = this.findReportsResult(jobId);
        for (ReportResult reportResult : list) {
            session.delete((Object)reportResult);
        }
    }

    @Override
    public List<ReportResult> findReportsResult(UUID jobId) {
        Query query = this.sessionFactory.getCurrentSession().createQuery("from ReportResult where jobId = :jobId").setParameter("jobId", (Object)jobId);
        return Collections.checkedList(query.list(), ReportResult.class);
    }
}

