/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.widgets.ChassisWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.ElementSelectionListener;

public class ChassisTab
extends ObjectTab
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private Composite content;
    private ChassisWidget chassisFrontWidget;
    private ChassisWidget chassisRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    @Override
    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 256);
        this.content = new Composite((Composite)this.scroller, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (ChassisTab.this.chassisFrontWidget == null || ChassisTab.this.chassisRearWidget == null || wHint == -1) {
                    return super.computeSize(wHint, hHint, changed);
                }
                Point s = ChassisTab.this.chassisFrontWidget.computeSize(wHint, hHint, changed);
                return new Point(s.x, s.y * 2);
            }
        };
        this.content.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)parent.getDisplay()));
        this.content.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChassisTab.this.chassisFrontWidget == null || ChassisTab.this.chassisRearWidget == null) {
                    return;
                }
                ChassisTab.this.updateChassisWidgetsSize();
            }
        });
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.getHorizontalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ChassisTab.this.scroller.setMinSize(ChassisTab.this.content.computeSize(((ChassisTab)ChassisTab.this).scroller.getSize().x, ((ChassisTab)ChassisTab.this).scroller.getSize().y));
            }
        });
    }

    protected void updateChassisWidgetsSize() {
        int width = this.content.getSize().x;
        int height = this.content.getSize().y;
        Point size = this.chassisFrontWidget.computeSize(width, height, true);
        this.chassisFrontWidget.setSize(size);
        this.chassisRearWidget.setSize(size);
        this.chassisRearWidget.setLocation(0, size.y);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ChassisTab.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chassisFrontWidget);
        this.chassisFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.chassisRearWidget);
        this.chassisRearWidget.setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this);
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void objectChanged(AbstractObject object) {
        if (this.chassisFrontWidget != null) {
            this.chassisFrontWidget.dispose();
            this.chassisFrontWidget = null;
        }
        if (this.chassisRearWidget != null) {
            this.chassisRearWidget.dispose();
            this.chassisRearWidget = null;
        }
        if (object != null) {
            ElementSelectionListener listener = new ElementSelectionListener(){

                @Override
                public void objectSelected(Object object) {
                    ChassisTab.this.selection = (ISelection)(object != null ? new StructuredSelection(object) : new StructuredSelection());
                    for (ISelectionChangedListener listener : ChassisTab.this.selectionListeners) {
                        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ChassisTab.this, ChassisTab.this.selection));
                    }
                }
            };
            this.chassisFrontWidget = new ChassisWidget(this.content, 0, (Chassis)object, RackOrientation.FRONT, true);
            this.chassisFrontWidget.addSelectionListener(listener);
            this.chassisRearWidget = new ChassisWidget(this.content, 0, (Chassis)object, RackOrientation.REAR, true);
            this.chassisRearWidget.addSelectionListener(listener);
            this.scroller.setMinSize(this.content.computeSize(this.scroller.getSize().x, -1));
            this.updateChassisWidgetsSize();
            this.createPopupMenu();
        }
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Chassis;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    @Override
    public void selected() {
        super.selected();
        this.scroller.setContent((Control)this.content);
    }
}

