/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.algorithms;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.gef4.zest.layouts.interfaces.EntityLayout;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;

public class ExpansionAlgorithm
implements LayoutAlgorithm {
    private LayoutContext context;

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    public void applyLayout(boolean clean) {
        EntityLayout e;
        if (!clean) {
            return;
        }
        int intersections = 0;
        double scaleFactorX = 1.0;
        double scaleFactorY = 1.0;
        EntityLayout[] entities = this.context.getEntities();
        Arrays.sort(entities, new Comparator<EntityLayout>(){

            @Override
            public int compare(EntityLayout e1, EntityLayout e2) {
                return (int)Math.signum(e1.getLocation().x - e2.getLocation().x);
            }
        });
        HashSet<EntityLayout> currentElements = new HashSet<EntityLayout>();
        EntityLayout[] entityLayoutArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            e = entityLayoutArray[n2];
            DisplayIndependentPoint currLoc = e.getLocation();
            double currX = currLoc.x - e.getSize().width / 2.0;
            Iterator it = currentElements.iterator();
            while (it.hasNext()) {
                EntityLayout l = (EntityLayout)it.next();
                if (l.getLocation().x + l.getSize().width / 2.0 < currX) {
                    it.remove();
                } else {
                    double overlayY;
                    double distanceY = Math.abs(currLoc.y - l.getLocation().y);
                    if (distanceY < 1.0) {
                        distanceY = 1.0;
                    }
                    if ((overlayY = e.getSize().height / 2.0 + l.getSize().height / 2.0 - distanceY) >= 0.0) {
                        double psf;
                        ++intersections;
                        double distanceX = Math.abs(currLoc.x - l.getLocation().x);
                        double overlayX = e.getSize().width / 2.0 + l.getSize().width / 2.0 - distanceX;
                        if (overlayX < overlayY) {
                            psf = (distanceX + overlayX) / distanceX;
                            if (psf > scaleFactorX) {
                                scaleFactorX = psf;
                            }
                        } else {
                            psf = (distanceY + overlayY) / distanceY;
                            if (psf > scaleFactorY) {
                                scaleFactorY = psf;
                            }
                        }
                    }
                }
                if (scaleFactorX >= 8.0 && scaleFactorY >= 8.0) break;
            }
            if (scaleFactorX >= 8.0 && scaleFactorY >= 8.0) break;
            currentElements.add(e);
            ++n2;
        }
        if (intersections > 0) {
            if (scaleFactorX > 8.0) {
                scaleFactorX = 8.0;
            }
            if (scaleFactorY > 8.0) {
                scaleFactorY = 8.0;
            }
            entityLayoutArray = entities;
            n = entities.length;
            n2 = 0;
            while (n2 < n) {
                e = entityLayoutArray[n2];
                DisplayIndependentPoint p = e.getLocation();
                e.setLocation(p.x * scaleFactorX, p.y * scaleFactorY);
                ++n2;
            }
        }
    }
}

