/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets.internal;

import java.util.Arrays;
import org.eclipse.birt.chart.model.component.Series;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;

public class DataComparisonElement {
    private GraphItem dci;
    private Threshold[] thresholds;
    private double value;
    private String rawValue;
    private Series series;

    public DataComparisonElement(GraphItem dci, double value, String rawValue) {
        this.dci = dci;
        this.value = value;
        this.rawValue = rawValue;
        this.series = null;
        this.thresholds = new Threshold[0];
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getRawValue() {
        return this.rawValue != null ? this.rawValue : Double.toString(this.value);
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public String getName() {
        return this.dci.getDescription();
    }

    public GraphItem getObject() {
        return this.dci;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public Threshold[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Threshold[] thresholds) {
        this.thresholds = thresholds;
    }

    public double getMaxThresholdValue(double defval) {
        double value = 0.0;
        Threshold[] thresholdArray = this.thresholds;
        int n = this.thresholds.length;
        int n2 = 0;
        while (n2 < n) {
            Threshold t = thresholdArray[n2];
            if (t.getOperation() == 2 || t.getOperation() == 3 || t.getOperation() == 4) {
                try {
                    double v = Double.parseDouble(t.getValue());
                    if (v > value) {
                        value = v;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return value > 0.0 ? value : defval;
    }

    public double getMinThresholdValue(double defval) {
        double value = Double.MAX_VALUE;
        Threshold[] thresholdArray = this.thresholds;
        int n = this.thresholds.length;
        int n2 = 0;
        while (n2 < n) {
            Threshold t = thresholdArray[n2];
            if (t.getOperation() == 2 || t.getOperation() == 3 || t.getOperation() == 4) {
                try {
                    double v = Double.parseDouble(t.getValue());
                    if (v < value) {
                        value = v;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return value < Double.MAX_VALUE ? value : defval;
    }

    public Severity getActiveThresholdSeverity() {
        Severity s = Severity.NORMAL;
        Threshold[] thresholdArray = this.thresholds;
        int n = this.thresholds.length;
        int n2 = 0;
        while (n2 < n) {
            Threshold t = thresholdArray[n2];
            if (t.isActive() && s.getValue() < t.getCurrentSeverity().getValue()) {
                s = t.getCurrentSeverity();
            }
            ++n2;
        }
        return s;
    }

    public String getDisplayFormat() {
        return this.dci.getDisplayFormat();
    }

    public String toString() {
        return "DataComparisonElement [dci=" + this.dci + ", thresholds=" + Arrays.toString(this.thresholds) + ", value=" + this.value + ", rawValue=" + this.rawValue + ", series=" + this.series + "]";
    }
}

