/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalLink;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.dialogs.PhysicalLinkEditDialog;
import org.netxms.ui.eclipse.objectview.widgets.helpers.PhysicalLinkComparator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.PhysicalLinkFilter;
import org.netxms.ui.eclipse.objectview.widgets.helpers.PhysicalLinkLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PhysicalLinkWidget
extends Composite
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.objectmanager.views.PhysicalLinkView";
    private static final String TABLE_CONFIG_PREFIX = "PhysicalLinkView";
    public static final int PHYSICAL_LINK_ID = 0;
    public static final int DESCRIPTOIN = 1;
    public static final int LEFT_OBJECT = 2;
    public static final int LEFT_PORT = 3;
    public static final int RIGHT_OBJECT = 4;
    public static final int RIGHT_PORT = 5;
    private ViewPart viewPart;
    private NXCSession session = ConsoleSharedData.getSession();
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionAdd;
    private Action actionDelete;
    private Action actionEdit;
    private Action actionShowFilter;
    private List<PhysicalLink> linkList;
    private long objectId;
    private long patchPanelId;
    private VisibilityValidator visibilityValidator;
    private CompositeWithMessageBar messageBarComposite;
    private Composite content;
    private FilterText filterText;
    private PhysicalLinkFilter filter;
    private boolean initShowFilter = true;

    public PhysicalLinkWidget(ViewPart viewPart, Composite parent, int style, long objectId, long patchPanelId, boolean enablefilter, VisibilityValidator visibilityValidator) {
        super(parent, style);
        this.viewPart = viewPart;
        this.objectId = objectId;
        this.patchPanelId = patchPanelId;
        this.initShowFilter = enablefilter;
        this.visibilityValidator = visibilityValidator;
        this.setLayout((Layout)new FillLayout());
        this.messageBarComposite = new CompositeWithMessageBar((Composite)this, 0);
        this.content = new Composite((Composite)this.messageBarComposite, 0);
        this.messageBarComposite.setContent(this.content);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PhysicalLinkWidget.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                PhysicalLinkWidget.this.enableFilter(false);
                PhysicalLinkWidget.this.actionShowFilter.setChecked(PhysicalLinkWidget.this.initShowFilter);
            }
        });
        int[] widths = new int[]{50, 200, 200, 400, 200, 400};
        String[] names = new String[]{"Id", "Description", "Object 1", "Port 1", "Object 2", "Port 2"};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        PhysicalLinkLabelProvider labelPrivater = new PhysicalLinkLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelPrivater);
        this.viewer.setComparator((ViewerComparator)new PhysicalLinkComparator(labelPrivater));
        this.filter = new PhysicalLinkFilter(labelPrivater);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PhysicalLinkWidget.this.actionEdit.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    PhysicalLinkWidget.this.actionEdit.setEnabled(selection.size() == 1);
                    PhysicalLinkWidget.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)PhysicalLinkWidget.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)PhysicalLinkWidget.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.linkList = new ArrayList<PhysicalLink>();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    public void refresh() {
        if (this.objectId == -1L) {
            return;
        }
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        new ConsoleJob("Load physical links", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PhysicalLinkWidget.this.linkList = PhysicalLinkWidget.this.session.getPhysicalLinks(PhysicalLinkWidget.this.objectId, PhysicalLinkWidget.this.patchPanelId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PhysicalLinkWidget.this.viewer.setInput((Object)PhysicalLinkWidget.this.linkList);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error getting physical link list";
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PhysicalLinkWidget.this.messageBarComposite.showMessage(2, String.format("%s (%s)", this.getErrorMessage(), e.getLocalizedMessage()));
                    }
                });
                return Status.OK_STATUS;
            }
        }.start();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PhysicalLinkWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionRefresh);
    }

    public void contributeToActionBars() {
        IActionBars bars = this.viewPart.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.actionAdd);
        toolBarManager.add((IAction)this.actionRefresh);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionShowFilter);
    }

    private void fillLocalPullDown(IMenuManager menuManager) {
        menuManager.add((IAction)this.actionAdd);
        menuManager.add((IAction)this.actionRefresh);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.actionShowFilter);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.viewPart.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                PhysicalLinkWidget.this.refresh();
            }
        };
        this.actionAdd = new Action("Create new"){

            public void run() {
                PhysicalLinkWidget.this.addPhysicalLink();
            }
        };
        this.actionAdd.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionDelete = new Action("Delete"){

            public void run() {
                PhysicalLinkWidget.this.deletePhysicalLink();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionEdit = new Action("Edit..."){

            public void run() {
                PhysicalLinkWidget.this.editPhysicalLink();
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                PhysicalLinkWidget.this.enableFilter(PhysicalLinkWidget.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objectview.commands.show_physical_link_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void editPhysicalLink() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return;
        }
        PhysicalLink link = (PhysicalLink)selection.getFirstElement();
        PhysicalLinkEditDialog dlg = new PhysicalLinkEditDialog(this.getShell(), link);
        if (dlg.open() != 0) {
            return;
        }
        final PhysicalLink editedLink = dlg.getLink();
        new ConsoleJob("Edit physical link", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PhysicalLinkWidget.this.session.updatePhysicalLink(editedLink);
            }

            protected String getErrorMessage() {
                return "Error editing physical link";
            }
        }.start();
    }

    private void deletePhysicalLink() {
        String message;
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String string = message = selection.size() == 1 ? "Do you really want to delete the selected physical link?" : "Do you really want to delete the selected categories?";
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Confirm p-hysical link deletion", (String)message)) {
            return;
        }
        new ConsoleJob("Delete physical link", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    PhysicalLinkWidget.this.session.deletePhysicalLink(((PhysicalLink)o).getId());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete physical link";
            }
        }.start();
    }

    private void addPhysicalLink() {
        PhysicalLinkEditDialog dlg = new PhysicalLinkEditDialog(this.getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        final PhysicalLink link = dlg.getLink();
        new ConsoleJob("Create new physical ink", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PhysicalLinkWidget.this.session.updatePhysicalLink(link);
            }

            protected String getErrorMessage() {
                return "Cannot create physical link";
            }
        }.start();
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ObjectTools.showFilter", this.initShowFilter);
        super.dispose();
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1043: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PhysicalLinkWidget.this.refresh();
                    }
                });
            }
        }
    }

    public void setSourceObject(long objectId, long patchPanelId) {
        this.objectId = objectId;
        this.patchPanelId = patchPanelId;
        this.refresh();
    }

    public boolean isFilterEnabled() {
        return this.initShowFilter;
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }
}

