/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages.helpers;

import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AttrListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_INHERITED = new Color((Device)Display.getDefault(), new RGB(220, 220, 220));
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
    private NXCSession session = ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 3) {
            CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
            AbstractObject object = this.session.findObjectById(attr.getSourceObject());
            return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof Map.Entry)) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                Object obj = ((Map.Entry)element).getKey();
                return obj instanceof String ? (String)obj : null;
            }
            case 1: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                return attr.getValue();
            }
            case 2: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                return (attr.getFlags() & 1L) > 0L ? "Yes" : "No";
            }
            case 3: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                if (attr.getSourceObject() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(attr.getSourceObject());
                return object != null ? object.getObjectName() : "[" + Long.toString(attr.getSourceObject()) + "]";
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
        if (attr.getSourceObject() != 0L && (attr.getFlags() & 2L) == 0L) {
            return COLOR_INHERITED;
        }
        return null;
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

