/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.ui.eclipse.console.resources.DataCollectionDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectInternalParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectParameterScriptDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectWebServiceDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.WinPerfCounterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends DCIPropertyPageDialog {
    private static final String[] snmpRawTypes;
    private DataCollectionItem dci;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Combo dataType;
    private Button checkInterpretRawSnmpValue;
    private Combo snmpRawType;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private Button checkUseCustomSnmpVersion;
    private Combo customSnmpVersion;
    private ObjectSelector sourceNode;
    private Combo agentCacheMode;
    private Combo schedulingMode;
    private Combo retentionMode;
    private LabeledText pollingInterval;
    private LabeledText retentionTime;
    private LabeledSpinner sampleCount;
    private static final DataType[] TYPES;

    static {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.General_SNMP_DT_None;
        Messages.get();
        stringArray[1] = Messages.General_SNMP_DT_int32;
        Messages.get();
        stringArray[2] = Messages.General_SNMP_DT_uint32;
        Messages.get();
        stringArray[3] = Messages.General_SNMP_DT_int64;
        Messages.get();
        stringArray[4] = Messages.General_SNMP_DT_uint64;
        Messages.get();
        stringArray[5] = Messages.General_SNMP_DT_float;
        Messages.get();
        stringArray[6] = Messages.General_SNMP_DT_ipAddr;
        Messages.get();
        stringArray[7] = Messages.General_SNMP_DT_macAddr;
        snmpRawTypes = stringArray;
        TYPES = new DataType[]{DataType.INT32, DataType.UINT32, DataType.COUNTER32, DataType.INT64, DataType.UINT64, DataType.COUNTER64, DataType.FLOAT, DataType.STRING};
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        Messages.get();
        groupDescription.setText(Messages.General_Description);
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        Messages.get();
        groupData.setText(Messages.General_Data);
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        Messages.get();
        this.parameter.setLabel(Messages.General_Parameter);
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        Messages.get();
        this.selectButton.setText(Messages.General_Select);
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.selectParameter();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(50, -2);
        Messages.get();
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_Origin, (Object)fd);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceInternal);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceAgent);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSNMP);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWebService);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourcePush);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWinPerf);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceILO);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceScript);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSSH);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceMQTT);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceDeviceDriver);
        this.origin.select(this.dci.getOrigin().getValue());
        this.origin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.onOriginChange();
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        Messages.get();
        this.dataType = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_DataType, (Object)fd);
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.FLOAT));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.STRING));
        this.dataType.select(General.getDataTypePosition(this.dci.getDataType()));
        this.checkInterpretRawSnmpValue = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkInterpretRawSnmpValue.setText(Messages.General_InterpretRawValue);
        this.checkInterpretRawSnmpValue.setSelection(this.dci.isSnmpRawValueInOctetString());
        this.checkInterpretRawSnmpValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.snmpRawType.setEnabled(General.this.checkInterpretRawSnmpValue.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.origin.getParent(), 4, 1024);
        this.checkInterpretRawSnmpValue.setLayoutData((Object)fd);
        this.checkInterpretRawSnmpValue.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.snmpRawType = new Combo((Composite)groupData, 2056);
        int i = 0;
        while (i < snmpRawTypes.length) {
            this.snmpRawType.add(snmpRawTypes[i]);
            ++i;
        }
        this.snmpRawType.select(this.dci.getSnmpRawValueType());
        this.snmpRawType.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP && this.dci.isSnmpRawValueInOctetString());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 1024);
        fd.right = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 0, 131072);
        this.snmpRawType.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkUseCustomSnmpPort.setText(Messages.General_UseCustomPort);
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.customSnmpPort.setEnabled(General.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 131072);
        fd.top = new FormAttachment((Control)this.dataType.getParent(), 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpPort = new Spinner((Composite)groupData, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dci.getOrigin() == DataOrigin.SNMP && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dci.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        fd.right = new FormAttachment((Control)this.checkUseCustomSnmpPort, 0, 131072);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion = new Button((Composite)groupData, 32);
        this.checkUseCustomSnmpVersion.setText("Use custom SNMP version:");
        this.checkUseCustomSnmpVersion.setSelection(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        this.checkUseCustomSnmpVersion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.customSnmpVersion.setEnabled(General.this.checkUseCustomSnmpVersion.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.dataType.getParent(), 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.checkUseCustomSnmpVersion.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpVersion = new Combo((Composite)groupData, 2056);
        this.customSnmpVersion.add("1");
        this.customSnmpVersion.add("2c");
        this.customSnmpVersion.add("3");
        this.customSnmpVersion.select(General.indexFromSnmpVersion(this.dci.getSnmpVersion()));
        this.customSnmpVersion.setEnabled(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpVersion, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.customSnmpVersion.setLayoutData((Object)fd);
        this.sampleCount = new LabeledSpinner((Composite)groupData, 0);
        Messages.get();
        this.sampleCount.setLabel(Messages.General_SampleCountForAvg);
        this.sampleCount.setRange(0, 65535);
        this.sampleCount.setSelection(this.dci.getSampleCount());
        this.sampleCount.setEnabled(this.dci.getOrigin() == DataOrigin.WINPERF);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpRawType, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.sampleCount.setLayoutData((Object)fd);
        this.sourceNode = new ObjectSelector((Composite)groupData, 0, true);
        Messages.get();
        this.sourceNode.setLabel(Messages.General_ProxyNode);
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dci.getSourceNode());
        this.sourceNode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.sampleCount, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        Messages.get();
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_AgentCacheMode, (Object)fd);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Default);
        Messages.get();
        this.agentCacheMode.add(Messages.General_On);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Off);
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.agentCacheMode.setEnabled(this.dci.getOrigin() == DataOrigin.AGENT || this.dci.getOrigin() == DataOrigin.SNMP);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.sampleCount, 4, 1024);
        fd.right = new FormAttachment((Control)this.agentCacheMode.getParent(), -4, 16384);
        this.sourceNode.setLayoutData((Object)fd);
        Group groupPolling = new Group(dialogArea, 0);
        Messages.get();
        groupPolling.setText(Messages.General_Polling);
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.General_PollingMode, (Object)fd);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsDefault);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsCustom);
        Messages.get();
        this.schedulingMode.add(Messages.General_CustomSchedule);
        this.schedulingMode.select(this.dci.getPollingScheduleType());
        this.schedulingMode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        this.schedulingMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.pollingInterval.setEnabled(General.this.schedulingMode.getSelectionIndex() == 1);
            }
        });
        this.pollingInterval = new LabeledText((Composite)groupPolling, 0);
        Messages.get();
        this.pollingInterval.setLabel(Messages.General_PollingInterval);
        this.pollingInterval.setText(this.dci.getPollingInterval());
        this.pollingInterval.setEnabled(this.dci.getPollingScheduleType() == 1 && this.dci.getOrigin() != DataOrigin.PUSH);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        Group groupStorage = new Group(dialogArea, 0);
        Messages.get();
        groupStorage.setText(Messages.General_Storage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        GridLayout storageLayout = new GridLayout();
        storageLayout.numColumns = 2;
        storageLayout.horizontalSpacing = 4;
        groupStorage.setLayout((Layout)storageLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Messages.get();
        this.retentionMode = WidgetHelper.createLabeledCombo((Composite)groupStorage, (int)8, (String)Messages.General_RetentionMode, (Object)gd);
        Messages.get();
        this.retentionMode.add(Messages.General_UseDefaultRetention);
        Messages.get();
        this.retentionMode.add(Messages.General_UseCustomRetention);
        Messages.get();
        this.retentionMode.add(Messages.General_NoStorage);
        this.retentionMode.select(this.dci.getRetentionType());
        this.retentionMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int mode = General.this.retentionMode.getSelectionIndex();
                General.this.retentionTime.setEnabled(mode == 1);
            }
        });
        this.retentionTime = new LabeledText((Composite)groupStorage, 0);
        Messages.get();
        this.retentionTime.setLabel(Messages.General_RetentionTime);
        this.retentionTime.setText(this.dci.getRetentionTime());
        this.retentionTime.setEnabled(this.dci.getRetentionType() == 1);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        this.onOriginChange();
        return dialogArea;
    }

    private static int indexFromSnmpVersion(SnmpVersion version) {
        switch (version) {
            case V1: {
                return 0;
            }
            case V2C: {
                return 1;
            }
            case V3: {
                return 2;
            }
        }
        return -1;
    }

    private static SnmpVersion indexToSnmpVersion(int index) {
        switch (index) {
            case 0: {
                return SnmpVersion.V1;
            }
            case 1: {
                return SnmpVersion.V2C;
            }
            case 2: {
                return SnmpVersion.V3;
            }
        }
        return SnmpVersion.DEFAULT;
    }

    private void onOriginChange() {
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        this.sourceNode.setEnabled(dataOrigin != DataOrigin.PUSH);
        this.schedulingMode.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT);
        this.pollingInterval.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT && this.schedulingMode.getSelectionIndex() == 1);
        this.checkInterpretRawSnmpValue.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.snmpRawType.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkInterpretRawSnmpValue.getSelection());
        this.checkUseCustomSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpPort.getSelection());
        this.checkUseCustomSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpVersion.getSelection());
        this.sampleCount.setEnabled(dataOrigin == DataOrigin.WINPERF);
        this.agentCacheMode.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP);
        this.selectButton.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP || dataOrigin == DataOrigin.INTERNAL || dataOrigin == DataOrigin.WINPERF || dataOrigin == DataOrigin.WEB_SERVICE || dataOrigin == DataOrigin.DEVICE_DRIVER || dataOrigin == DataOrigin.SCRIPT);
    }

    private void selectParameter() {
        IParameterSelectionDialog dlg;
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        switch (dataOrigin) {
            case INTERNAL: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectInternalParamDlg(this.getShell(), this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectInternalParamDlg(this.getShell(), this.dci.getNodeId());
                break;
            }
            case AGENT: 
            case DEVICE_DRIVER: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectAgentParamDlg(this.getShell(), this.sourceNode.getObjectId(), dataOrigin, false);
                    break;
                }
                dlg = new SelectAgentParamDlg(this.getShell(), this.dci.getNodeId(), dataOrigin, false);
                break;
            }
            case SNMP: {
                SnmpObjectId oid;
                try {
                    oid = SnmpObjectId.parseSnmpObjectId((String)this.parameter.getText());
                }
                catch (SnmpObjectIdFormatException e) {
                    oid = null;
                }
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.dci.getNodeId());
                break;
            }
            case WINPERF: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new WinPerfCounterSelectionDialog(this.getShell(), this.sourceNode.getObjectId());
                    break;
                }
                dlg = new WinPerfCounterSelectionDialog(this.getShell(), this.dci.getNodeId());
                break;
            }
            case SCRIPT: {
                dlg = new SelectParameterScriptDialog(this.getShell());
                break;
            }
            case WEB_SERVICE: {
                dlg = new SelectWebServiceDlg(this.getShell(), false);
                break;
            }
            default: {
                dlg = null;
            }
        }
        if (dlg != null && dlg.open() == 0) {
            IParameterSelectionDialog pd = dlg;
            this.description.setText(pd.getParameterDescription());
            this.parameter.setText(pd.getParameterName());
            this.dataType.select(General.getDataTypePosition(pd.getParameterDataType()));
            this.editor.fireOnSelectItemListeners(DataOrigin.getByValue((int)this.origin.getSelectionIndex()), pd.getParameterName(), pd.getParameterDescription(), pd.getParameterDataType());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(DataOrigin.getByValue((int)this.origin.getSelectionIndex()));
        this.dci.setDataType(General.getDataTypeByPosition(this.dataType.getSelectionIndex()));
        this.dci.setSampleCount(this.sampleCount.getSelection());
        this.dci.setSourceNode(this.sourceNode.getObjectId());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setPollingScheduleType(this.schedulingMode.getSelectionIndex());
        this.dci.setPollingInterval(this.schedulingMode.getSelectionIndex() == 1 ? this.pollingInterval.getText() : null);
        this.dci.setRetentionType(this.retentionMode.getSelectionIndex());
        this.dci.setRetentionTime(this.retentionMode.getSelectionIndex() == 1 ? this.retentionTime.getText() : null);
        this.dci.setSnmpRawValueInOctetString(this.checkInterpretRawSnmpValue.getSelection());
        this.dci.setSnmpRawValueType(this.snmpRawType.getSelectionIndex());
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(this.customSnmpPort.getSelection());
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.checkUseCustomSnmpVersion.getSelection()) {
            this.dci.setSnmpVersion(General.indexToSnmpVersion(this.customSnmpVersion.getSelectionIndex()));
        } else {
            this.dci.setSnmpVersion(SnmpVersion.DEFAULT);
        }
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        NXCSession session = ConsoleSharedData.getSession();
        this.schedulingMode.select(0);
        this.pollingInterval.setText(Integer.toString(session.getDefaultDciPollingInterval()));
        this.retentionMode.select(0);
        this.retentionTime.setText(Integer.toString(session.getDefaultDciRetentionTime()));
        this.checkInterpretRawSnmpValue.setSelection(false);
        this.checkUseCustomSnmpPort.setSelection(false);
        this.customSnmpPort.setSelection(161);
    }

    private static int getDataTypePosition(DataType type) {
        switch (type) {
            case COUNTER32: {
                return 2;
            }
            case COUNTER64: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case INT32: {
                return 0;
            }
            case INT64: {
                return 3;
            }
            case STRING: {
                return 7;
            }
            case UINT32: {
                return 1;
            }
            case UINT64: {
                return 4;
            }
        }
        return 0;
    }

    private static DataType getDataTypeByPosition(int position) {
        return TYPES[position];
    }
}

