/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.base.GeoLocation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.FontTools;

public abstract class AbstractGeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener,
MouseWheelListener,
MouseListener,
MouseMoveListener {
    protected static final String[] TITLE_FONTS = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", "Verdana", "Arial"};
    protected static final Color BORDER_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    protected static final int LABEL_ARROW_HEIGHT = 5;
    protected static final int LABEL_X_MARGIN = 4;
    protected static final int LABEL_Y_MARGIN = 4;
    protected static final int LABEL_SPACING = 4;
    private static final Color MAP_BACKGROUND = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color INFO_BLOCK_BACKGROUND = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color INFO_BLOCK_TEXT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 255);
    private static final int DRAG_JITTER = 8;
    protected ColorCache colorCache;
    protected ILabelProvider labelProvider;
    protected Area coverage = new Area(0.0, 0.0, 0.0, 0.0);
    protected MapAccessor accessor;
    protected IViewPart viewPart = null;
    protected Point currentPoint;
    private Image currentImage = null;
    private Image bufferImage = null;
    private MapLoader mapLoader;
    private Point dragStartPoint = null;
    private Point selectionStartPoint = null;
    private Point selectionEndPoint = null;
    private Set<GeoMapListener> mapListeners = new HashSet<GeoMapListener>(0);
    private String title = null;
    private int offsetX;
    private int offsetY;
    private TileSet currentTileSet = null;
    private Image imageZoomIn;
    private Image imageZoomOut;
    private Rectangle zoomControlRect = null;
    private Font mapTitleFont;

    public AbstractGeoMapViewer(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x20000000);
        this.colorCache = new ColorCache((Control)this);
        this.imageZoomIn = Activator.getImageDescriptor("icons/map_zoom_in.png").createImage();
        this.imageZoomOut = Activator.getImageDescriptor("icons/map_zoom_out.png").createImage();
        this.mapTitleFont = FontTools.createFont((String[])TITLE_FONTS, (int)2, (int)1);
        this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.mapLoader = new MapLoader(this.getDisplay());
        this.setBackground(MAP_BACKGROUND);
        this.addPaintListener(this);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (AbstractGeoMapViewer.this.isDisposed()) {
                    return;
                }
                AbstractGeoMapViewer.this.reloadMap();
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AbstractGeoMapViewer.this.getDisplay().timerExec(-1, timer);
                AbstractGeoMapViewer.this.getDisplay().timerExec(1000, timer);
                if (AbstractGeoMapViewer.this.bufferImage != null) {
                    AbstractGeoMapViewer.this.bufferImage.dispose();
                }
                Rectangle rect = AbstractGeoMapViewer.this.getClientArea();
                AbstractGeoMapViewer.this.bufferImage = new Image((Device)AbstractGeoMapViewer.this.getDisplay(), rect.width, rect.height);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractGeoMapViewer.this.labelProvider.dispose();
                GeoLocationCache.getInstance().removeListener(AbstractGeoMapViewer.this);
                if (AbstractGeoMapViewer.this.bufferImage != null) {
                    AbstractGeoMapViewer.this.bufferImage.dispose();
                }
                if (AbstractGeoMapViewer.this.currentImage != null) {
                    AbstractGeoMapViewer.this.currentImage.dispose();
                }
                AbstractGeoMapViewer.this.mapLoader.dispose();
                AbstractGeoMapViewer.this.imageZoomIn.dispose();
                AbstractGeoMapViewer.this.imageZoomOut.dispose();
                AbstractGeoMapViewer.this.mapTitleFont.dispose();
            }
        });
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseWheelListener(this);
        GeoLocationCache.getInstance().addListener(this);
    }

    public void addMapListener(GeoMapListener listener) {
        this.mapListeners.add(listener);
    }

    public void removeMapListener(GeoMapListener listener) {
        this.mapListeners.remove(listener);
    }

    private void notifyOnZoomChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onZoom(this.accessor.getZoom());
        }
    }

    private void notifyOnPositionChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onPan(this.accessor.getCenterPoint());
        }
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    public void showMap(double lat, double lon, int zoom) {
        this.showMap(new MapAccessor(lat, lon, zoom));
    }

    public void reloadMap() {
        Rectangle rect = this.getClientArea();
        this.accessor.setMapWidth(rect.width);
        this.accessor.setMapHeight(rect.height);
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        this.currentImage = null;
        if (!this.accessor.isValid()) {
            return;
        }
        final Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
        final GeoLocation centerPoint = this.accessor.getCenterPoint();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_DownloadJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = AbstractGeoMapViewer.this.mapLoader.getAllTiles(mapSize, centerPoint, 0, AbstractGeoMapViewer.this.accessor.getZoom(), true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractGeoMapViewer.this.isDisposed()) {
                            return;
                        }
                        AbstractGeoMapViewer.this.currentTileSet = null;
                        if (tiles != null) {
                            AbstractGeoMapViewer.this.drawTiles(tiles);
                            AbstractGeoMapViewer.this.redraw();
                            if (tiles.missingTiles > 0) {
                                AbstractGeoMapViewer.this.currentTileSet = tiles;
                                AbstractGeoMapViewer.this.loadMissingTiles(tiles);
                            } else {
                                tiles.dispose();
                            }
                        }
                        Point mapSize = new Point(((AbstractGeoMapViewer)(this).AbstractGeoMapViewer.this).currentImage.getImageData().width, ((AbstractGeoMapViewer)(this).AbstractGeoMapViewer.this).currentImage.getImageData().height);
                        (this).AbstractGeoMapViewer.this.coverage = GeoLocationCache.calculateCoverage(mapSize, (this).AbstractGeoMapViewer.this.accessor.getCenterPoint(), 0, (this).AbstractGeoMapViewer.this.accessor.getZoom());
                        AbstractGeoMapViewer.this.onMapLoad();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    protected abstract void onMapLoad();

    private void loadMissingTiles(final TileSet tiles) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_LoadMissingJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractGeoMapViewer.this.mapLoader.loadMissingTiles(tiles, new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractGeoMapViewer.this.isDisposed() && AbstractGeoMapViewer.this.currentTileSet == tiles) {
                            AbstractGeoMapViewer.this.drawTiles(tiles);
                            AbstractGeoMapViewer.this.redraw();
                        } else {
                            tiles.cancelled = true;
                        }
                        if (tiles.missingTiles == 0) {
                            tiles.dispose();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.currentImage = null;
            return;
        }
        Tile[][] tiles = tileSet.tiles;
        Point size = this.getSize();
        this.currentImage = new Image((Device)this.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.currentImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j].getImage(), x, y);
                if ((x += 256) >= size.x) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    public void paintControl(PaintEvent e) {
        int x;
        GeoLocation currentLocation;
        GC gc = new GC((Drawable)this.bufferImage);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.dragStartPoint == null) {
            int imgH;
            int imgW;
            currentLocation = this.accessor.getCenterPoint();
            if (this.currentImage != null) {
                gc.drawImage(this.currentImage, -this.offsetX, -this.offsetY);
                imgW = this.currentImage.getImageData().width;
                imgH = this.currentImage.getImageData().height;
            } else {
                imgW = -1;
                imgH = -1;
            }
            this.drawContent(gc, currentLocation, imgW, imgH);
        } else {
            Point cp = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
            cp.x += this.offsetX;
            cp.y += this.offsetY;
            currentLocation = GeoLocationCache.displayToCoordinates(cp, this.accessor.getZoom());
            Point size = this.getSize();
            TileSet tileSet = this.mapLoader.getAllTiles(size, currentLocation, 0, this.accessor.getZoom(), true);
            x = tileSet.xOffset;
            int y = tileSet.yOffset;
            Tile[][] tiles = tileSet.tiles;
            int i = 0;
            while (i < tiles.length) {
                int j = 0;
                while (j < tiles[i].length) {
                    gc.drawImage(tiles[i][j].getImage(), x, y);
                    if ((x += 256) >= size.x) {
                        x = tileSet.xOffset;
                        y += 256;
                    }
                    ++j;
                }
                ++i;
            }
            tileSet.dispose();
        }
        if (this.selectionStartPoint != null && this.selectionEndPoint != null) {
            int x2 = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
            int y = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
            int w = Math.abs(this.selectionStartPoint.x - this.selectionEndPoint.x);
            int h = Math.abs(this.selectionStartPoint.y - this.selectionEndPoint.y);
            gc.setBackground(SELECTION_COLOR);
            gc.setForeground(SELECTION_COLOR);
            gc.setAlpha(64);
            gc.fillRectangle(x2, y, w, h);
            gc.setAlpha(255);
            gc.setLineWidth(2);
            gc.drawRectangle(x2, y, w, h);
        }
        String text = currentLocation.toString();
        Point textSize = gc.textExtent(text);
        Rectangle rect = this.getClientArea();
        rect.x = rect.width - textSize.x - 20;
        rect.y += 10;
        rect.width = textSize.x + 10;
        rect.height = textSize.y + 8;
        gc.setBackground(INFO_BLOCK_BACKGROUND);
        gc.setAlpha(128);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setAlpha(255);
        gc.setForeground(INFO_BLOCK_TEXT);
        gc.drawText(text, rect.x + 5, rect.y + 4, true);
        if (this.title != null && !this.title.isEmpty()) {
            gc.setFont(this.mapTitleFont);
            rect = this.getClientArea();
            x = (rect.width - gc.textExtent((String)this.title).x) / 2;
            gc.setForeground(ThemeEngine.getForegroundColor((String)"GeoMap.Title"));
            gc.drawText(this.title, x, 10, true);
        }
        gc.setFont(JFaceResources.getHeaderFont());
        text = Integer.toString(this.accessor.getZoom());
        textSize = gc.textExtent(text);
        rect = this.getClientArea();
        rect.x = 10;
        rect.y = 10;
        rect.width = 80;
        rect.height = 47 + textSize.y;
        gc.setBackground(INFO_BLOCK_BACKGROUND);
        gc.setForeground(INFO_BLOCK_TEXT);
        gc.setAlpha(128);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setAlpha(255);
        gc.drawText(text, rect.x + rect.width / 2 - textSize.x / 2, rect.y + 5, true);
        gc.drawImage(this.imageZoomIn, rect.x + 5, rect.y + rect.height - 37);
        gc.drawImage(this.imageZoomOut, rect.x + 42, rect.y + rect.height - 37);
        this.zoomControlRect = rect;
        gc.dispose();
        e.gc.drawImage(this.bufferImage, 0, 0);
    }

    protected abstract void drawContent(GC var1, GeoLocation var2, int var3, int var4);

    @Override
    public void geoLocationCacheChanged(final AbstractObject object, final GeoLocation prevLocation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractGeoMapViewer.this.onCacheChange(object, prevLocation);
            }
        });
    }

    protected abstract void onCacheChange(AbstractObject var1, GeoLocation var2);

    public void mouseScrolled(MouseEvent event) {
        int zoom = this.accessor.getZoom();
        if (event.count > 0) {
            if (zoom < 19) {
                ++zoom;
            }
        } else if (zoom > 1) {
            --zoom;
        }
        if (zoom != this.accessor.getZoom()) {
            this.accessor.setZoom(zoom);
            this.reloadMap();
            this.notifyOnZoomChange();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        int zoom = this.accessor.getZoom();
        if (zoom < 19) {
            int step = (e.stateMask & 0x20000) != 0 ? 4 : 1;
            zoom = zoom + step > 19 ? 19 : zoom + step;
            GeoLocation geoLocation = this.getLocationAtPoint(new Point(e.x, e.y));
            this.accessor.setZoom(zoom);
            this.accessor.setLatitude(geoLocation.getLatitude());
            this.accessor.setLongitude(geoLocation.getLongitude());
            this.reloadMap();
            this.notifyOnZoomChange();
            this.notifyOnPositionChange();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            if (this.zoomControlRect.contains(e.x, e.y)) {
                Rectangle r = new Rectangle(this.zoomControlRect.x + 5, this.zoomControlRect.y + this.zoomControlRect.height - 37, 32, 32);
                int zoom = this.accessor.getZoom();
                if (r.contains(e.x, e.y)) {
                    if (zoom < 19) {
                        ++zoom;
                    }
                } else {
                    r.x += 37;
                    if (r.contains(e.x, e.y) && zoom > 1) {
                        --zoom;
                    }
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.reloadMap();
                    this.notifyOnZoomChange();
                }
            } else if ((e.stateMask & 0x20000) != 0) {
                if (this.accessor.getZoom() < 19) {
                    this.selectionStartPoint = new Point(e.x, e.y);
                }
            } else {
                this.dragStartPoint = new Point(e.x, e.y);
                this.setCursor(this.getDisplay().getSystemCursor(5));
            }
        }
        this.currentPoint = new Point(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.dragStartPoint != null) {
            if (Math.abs(this.offsetX) > 8 || Math.abs(this.offsetY) > 8) {
                Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
                centerXY.x += this.offsetX;
                centerXY.y += this.offsetY;
                GeoLocation geoLocation = GeoLocationCache.displayToCoordinates(centerXY, this.accessor.getZoom());
                this.accessor.setLatitude(geoLocation.getLatitude());
                this.accessor.setLongitude(geoLocation.getLongitude());
                this.reloadMap();
                this.notifyOnPositionChange();
            }
            this.offsetX = 0;
            this.offsetY = 0;
            this.dragStartPoint = null;
            this.setCursor(null);
        }
        if (e.button == 1 && this.selectionStartPoint != null) {
            if (this.selectionEndPoint != null) {
                int x1 = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int x2 = Math.max(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int y1 = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
                int y2 = Math.max(this.selectionStartPoint.y, this.selectionEndPoint.y);
                GeoLocation l1 = this.getLocationAtPoint(new Point(x1, y1));
                GeoLocation l2 = this.getLocationAtPoint(new Point(x2, y2));
                GeoLocation lc = this.getLocationAtPoint(new Point(x2 - (x2 - x1) / 2, y2 - (y2 - y1) / 2));
                int zoom = this.accessor.getZoom();
                while (zoom < 19) {
                    Area area = GeoLocationCache.calculateCoverage(this.getSize(), lc, 0, ++zoom);
                    if (area.contains(l1.getLatitude(), l1.getLongitude()) && area.contains(l2.getLatitude(), l2.getLongitude())) continue;
                    --zoom;
                    break;
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.accessor.setLatitude(lc.getLatitude());
                    this.accessor.setLongitude(lc.getLongitude());
                    this.reloadMap();
                    this.notifyOnPositionChange();
                    this.notifyOnZoomChange();
                }
            }
            this.selectionStartPoint = null;
            this.selectionEndPoint = null;
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        int deltaY;
        int deltaX;
        if (this.dragStartPoint != null) {
            deltaX = this.dragStartPoint.x - e.x;
            deltaY = this.dragStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.offsetX = deltaX;
                this.offsetY = deltaY;
                this.redraw();
            }
        }
        if (this.selectionStartPoint != null) {
            deltaX = this.selectionStartPoint.x - e.x;
            deltaY = this.selectionStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.selectionEndPoint = new Point(e.x, e.y);
                this.redraw();
            }
        }
    }

    public Point getCurrentPoint() {
        return new Point(this.currentPoint.x, this.currentPoint.y);
    }

    public GeoLocation getLocationAtPoint(Point p) {
        Point cp = GeoLocationCache.coordinateToDisplay(new GeoLocation(this.coverage.getxHigh(), this.coverage.getyLow()), this.accessor.getZoom());
        return GeoLocationCache.displayToCoordinates(new Point(cp.x + p.x, cp.y + p.y), this.accessor.getZoom());
    }

    public IViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewPart(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public abstract AbstractObject getObjectAtPoint(Point var1);
}

