/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs.pages;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.WebServiceAuthType;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class WebServiceGeneral
extends PreferencePage {
    private WebServiceDefinition definition;
    private LabeledText name;
    private LabeledText url;
    private Button checkVerifyCert;
    private Button checkVerifyHost;
    private Button checkTextParsing;
    private Combo authType;
    private LabeledText login;
    private LabeledText password;
    private LabeledSpinner retentionTime;
    private LabeledSpinner timeout;
    private LabeledText description;

    public WebServiceGeneral(WebServiceDefinition definition) {
        super("General");
        this.noDefaultAndApplyButton();
        this.definition = definition;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.definition.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.url = new LabeledText(dialogArea, 0);
        this.url.setLabel("URL");
        this.url.setText(this.definition.getUrl());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.url.setLayoutData((Object)gd);
        this.checkVerifyCert = new Button(dialogArea, 32);
        this.checkVerifyCert.setText("Verify the peer's SSL certificate");
        this.checkVerifyCert.setSelection(this.definition.isVerifyCertificate());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkVerifyCert.setLayoutData((Object)gd);
        this.checkVerifyHost = new Button(dialogArea, 32);
        this.checkVerifyHost.setText("Verify the certificate's name against host");
        this.checkVerifyHost.setSelection(this.definition.isVerifyHost());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkVerifyHost.setLayoutData((Object)gd);
        this.checkTextParsing = new Button(dialogArea, 32);
        this.checkTextParsing.setText("Use text parsing to get data");
        this.checkTextParsing.setSelection(this.definition.isTextParsingUsed());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkTextParsing.setLayoutData((Object)gd);
        Group groupAuth = new Group(dialogArea, 0);
        groupAuth.setText("Authentication");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        groupAuth.setLayoutData((Object)gd);
        layout = new GridLayout();
        groupAuth.setLayout((Layout)layout);
        this.authType = new Combo((Composite)groupAuth, 12);
        WebServiceAuthType[] webServiceAuthTypeArray = WebServiceAuthType.values();
        int n = webServiceAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WebServiceAuthType t = webServiceAuthTypeArray[n2];
            this.authType.add(t.toString());
            ++n2;
        }
        this.authType.select(this.definition.getAuthenticationType().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.authType.setLayoutData((Object)gd);
        this.login = new LabeledText((Composite)groupAuth, 0);
        this.login.setLabel("Login");
        this.login.setText(this.definition.getLogin());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.login.setLayoutData((Object)gd);
        this.password = new LabeledText((Composite)groupAuth, 0);
        this.password.setLabel("Password");
        this.password.setText(this.definition.getPassword());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.password.setLayoutData((Object)gd);
        Group groupOptions = new Group(dialogArea, 0);
        groupOptions.setText("Options");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        groupOptions.setLayoutData((Object)gd);
        layout = new GridLayout();
        groupOptions.setLayout((Layout)layout);
        this.retentionTime = new LabeledSpinner((Composite)groupOptions, 0);
        this.retentionTime.setLabel("Cache retention time");
        this.retentionTime.setRange(0, 3600);
        this.retentionTime.setSelection(this.definition.getCacheRetentionTime());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        this.timeout = new LabeledSpinner((Composite)groupOptions, 0);
        this.timeout.setLabel("Request timeout");
        this.timeout.setRange(0, 300);
        this.timeout.setSelection(this.definition.getRequestTimeout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeout.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0, 2818);
        this.description.setLabel("Description");
        this.description.setText(this.definition.getDescription());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.heightHint = 200;
        this.description.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        String svcName = this.name.getText().trim();
        if (svcName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Web service name cannot be empty!");
            return false;
        }
        if (svcName.contains(":") || svcName.contains("/") || svcName.contains(",") || svcName.contains("(") || svcName.contains(")") || svcName.contains("{") || svcName.contains("}") || svcName.contains("'") || svcName.contains("\"")) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Web service name cannot contain following characters: / , : ' \" ( ) { }");
            return false;
        }
        this.definition.setName(svcName);
        this.definition.setUrl(this.url.getText().trim());
        this.definition.setVerifyCertificate(this.checkVerifyCert.getSelection());
        this.definition.setVerifyHost(this.checkVerifyHost.getSelection());
        this.definition.setParseAsText(this.checkTextParsing.getSelection());
        this.definition.setAuthenticationType(WebServiceAuthType.getByValue((int)this.authType.getSelectionIndex()));
        this.definition.setLogin(this.login.getText().trim());
        this.definition.setPassword(this.password.getText());
        this.definition.setCacheRetentionTime(this.retentionTime.getSelection());
        this.definition.setRequestTimeout(this.timeout.getSelection());
        this.definition.setDescription(this.description.getText());
        return super.performOk();
    }
}

