/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.RerunTimeDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.ScheduledTaskEditor;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScheduleTableEntryComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScheduleTableEntryLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScheduledTaskFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ScheduledTaskView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.ScheduledTaskView";
    public static final int SCHEDULE_ID = 0;
    public static final int CALLBACK_ID = 1;
    public static final int OBJECT = 2;
    public static final int PARAMETERS = 3;
    public static final int EXECUTION_TIME = 4;
    public static final int LAST_EXECUTION_TIME = 5;
    public static final int STATUS = 6;
    public static final int MANAGMENT_STATE = 7;
    public static final int OWNER = 8;
    public static final int COMMENTS = 9;
    private NXCSession session;
    private SessionListener listener;
    private SortableTableViewer viewer;
    private ScheduledTaskFilter filter;
    private Action actionRefresh;
    private Action actionShowCompletedTasks;
    private Action actionShowDisabledTasks;
    private Action actionShowSystemTasks;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionDisable;
    private Action actionEnable;
    private Action actionReschedule;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{50, 100, 200, 400, 150, 150, 100, 200, 250, 200};
        String[] names = new String[]{"Id", "Schedule Type", "Object", "Parameters", "Execution time", "Last execution time", "Execution status", "Administrative status", "Owner", "Comments"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScheduleTableEntryLabelProvider(this.viewer));
        this.viewer.setComparator((ViewerComparator)new ScheduleTableEntryComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScheduledTaskView.this.actionEdit.run();
            }
        });
        this.filter = new ScheduledTaskFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"ScheduledTasks");
        this.filter.setShowCompletedTasks(ScheduledTaskView.getBooleanFromSettings(settings, "ScheduledTasks.showCompleted", true));
        this.filter.setShowDisabledTasks(ScheduledTaskView.getBooleanFromSettings(settings, "ScheduledTasks.showDisabled", true));
        this.filter.setShowSystemTasks(ScheduledTaskView.getBooleanFromSettings(settings, "ScheduledTasks.showSystem", false));
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ScheduledTaskView.this.viewer, (IDialogSettings)settings, (String)"ScheduledTasks");
                settings.put("ScheduledTasks.showCompleted", ScheduledTaskView.this.filter.isShowCompletedTasks());
                settings.put("ScheduledTasks.showDisabled", ScheduledTaskView.this.filter.isShowDisabledTasks());
                settings.put("ScheduledTasks.showSystem", ScheduledTaskView.this.filter.isShowSystemTasks());
            }
        });
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1029) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ScheduledTaskView.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    private static boolean getBooleanFromSettings(IDialogSettings settings, String name, boolean defaultValue) {
        if (settings.get(name) == null) {
            return defaultValue;
        }
        return settings.getBoolean(name);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.ScheduledTaskView");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ScheduledTaskView.this.refresh();
            }
        };
        this.actionShowCompletedTasks = new Action("Show &completed tasks", 2){

            public void run() {
                ScheduledTaskView.this.filter.setShowCompletedTasks(ScheduledTaskView.this.actionShowCompletedTasks.isChecked());
                ScheduledTaskView.this.viewer.refresh();
            }
        };
        this.actionShowCompletedTasks.setChecked(this.filter.isShowCompletedTasks());
        this.actionShowDisabledTasks = new Action("Show &disabled tasks", 2){

            public void run() {
                ScheduledTaskView.this.filter.setShowDisabledTasks(ScheduledTaskView.this.actionShowDisabledTasks.isChecked());
                ScheduledTaskView.this.viewer.refresh();
            }
        };
        this.actionShowDisabledTasks.setChecked(this.filter.isShowDisabledTasks());
        this.actionShowSystemTasks = new Action("Show &system tasks", 2){

            public void run() {
                ScheduledTaskView.this.filter.setShowSystemTasks(ScheduledTaskView.this.actionShowSystemTasks.isChecked());
                ScheduledTaskView.this.viewer.refresh();
            }
        };
        this.actionShowSystemTasks.setChecked(this.filter.isShowSystemTasks());
        this.actionCreate = new Action("New scheduled task...", SharedIcons.ADD_OBJECT){

            public void run() {
                ScheduledTaskView.this.createTask();
            }
        };
        this.actionCreate.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.new_task");
        handlerService.activateHandler(this.actionCreate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCreate));
        this.actionEdit = new Action("Edit...", SharedIcons.EDIT){

            public void run() {
                ScheduledTaskView.this.editTask();
            }
        };
        this.actionEdit.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.edit_task");
        handlerService.activateHandler(this.actionEdit.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionEdit));
        this.actionDelete = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ScheduledTaskView.this.deleteTask();
            }
        };
        this.actionDisable = new Action("Disable"){

            public void run() {
                ScheduledTaskView.this.setScheduledTaskEnabled(false);
            }
        };
        this.actionDisable.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.disable_task");
        handlerService.activateHandler(this.actionDisable.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDisable));
        this.actionEnable = new Action("Enable"){

            public void run() {
                ScheduledTaskView.this.setScheduledTaskEnabled(true);
            }
        };
        this.actionEnable.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.enable_task");
        handlerService.activateHandler(this.actionEnable.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionEnable));
        this.actionReschedule = new Action("Reschedule...", SharedIcons.EXECUTE){

            public void run() {
                ScheduledTaskView.this.rescheduleTask();
            }
        };
        this.actionReschedule.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.reschedule_task");
        handlerService.activateHandler(this.actionReschedule.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionReschedule));
    }

    protected void rescheduleTask() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
        final RerunTimeDialog dialog = new RerunTimeDialog(this.getSite().getShell(), origin.getExecutionTime());
        if (dialog.open() != 0) {
            return;
        }
        new ConsoleJob("Reschedule task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                origin.setExecutionTime(dialog.getRerunDate());
                origin.setFlags(origin.getFlags() & 0xFFFFFFFD);
                ScheduledTaskView.this.session.updateScheduledTask(origin);
            }

            protected String getErrorMessage() {
                return "Cannot reschedule tasks";
            }
        }.start();
    }

    protected void deleteTask() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm Task Delete", (String)(selection.size() == 1 ? "Selected task will be deleted. Are you sure?" : "Selected tasks will be deleted. Are you sure?"))) {
            return;
        }
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    ScheduledTaskView.this.session.deleteScheduledTask(((ScheduledTask)o).getId());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete scheduled tasks";
            }
        }.start();
    }

    protected void editTask() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
        new ConsoleJob("Update scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){
            private ScheduledTask task;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.task = null;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List taskList = ScheduledTaskView.this.session.getScheduledTaskHandlers();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledTaskEditor dialog = new ScheduledTaskEditor(ScheduledTaskView.this.getSite().getShell(), origin, taskList);
                        if (dialog.open() == 0) {
                            task = dialog.getScheduledTask();
                        }
                    }
                });
                if (this.task != null) {
                    ScheduledTaskView.this.session.updateScheduledTask(this.task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    protected void setScheduledTaskEnabled(final boolean enabled) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() < 0) {
            return;
        }
        new ConsoleJob("Update scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    ScheduledTask task = (ScheduledTask)o;
                    task.setEnabed(enabled);
                    ScheduledTaskView.this.session.updateScheduledTask(task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    private void createTask() {
        new ConsoleJob("Create scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){
            private ScheduledTask task;
            {
                this.task = null;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List taskList = ScheduledTaskView.this.session.getScheduledTaskHandlers();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledTaskEditor dialog = new ScheduledTaskEditor(ScheduledTaskView.this.getSite().getShell(), null, taskList);
                        if (dialog.open() == 0) {
                            task = dialog.getScheduledTask();
                        }
                    }
                });
                if (this.task != null) {
                    ScheduledTaskView.this.session.addScheduledTask(this.task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot create scheduled tasks";
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowCompletedTasks);
        manager.add((IAction)this.actionShowDisabledTasks);
        manager.add((IAction)this.actionShowSystemTasks);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScheduledTaskView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionEdit);
            ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
            if (origin.getSchedule().isEmpty()) {
                mgr.add((IAction)this.actionReschedule);
            }
        }
        boolean containDisabled = false;
        boolean containEnabled = false;
        for (Object o : selection.toList()) {
            if (((ScheduledTask)o).isDisabled()) {
                containDisabled = true;
            } else {
                containEnabled = true;
            }
            if (containDisabled && containEnabled) break;
        }
        if (containDisabled) {
            mgr.add((IAction)this.actionEnable);
        }
        if (containEnabled) {
            mgr.add((IAction)this.actionDisable);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCreate);
    }

    private void refresh() {
        new ConsoleJob("Reloading scheduled task list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List schedules = ScheduledTaskView.this.session.getScheduledTasks();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)ScheduledTaskView.this.viewer.getSelection();
                        ScheduledTaskView.this.viewer.setInput((Object)schedules.toArray());
                        if (!selection.isEmpty()) {
                            ArrayList<ScheduledTask> newSelection = new ArrayList<ScheduledTask>();
                            block0: for (Object o : selection.toList()) {
                                long id = ((ScheduledTask)o).getId();
                                for (ScheduledTask s : schedules) {
                                    if (s.getId() != id) continue;
                                    newSelection.add(s);
                                    continue block0;
                                }
                            }
                            if (!newSelection.isEmpty()) {
                                ScheduledTaskView.this.viewer.setSelection((ISelection)new StructuredSelection(newSelection));
                            }
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of scheduled tasks";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }
}

