/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.dialogs;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateNewCertificateDialog
extends Dialog {
    protected String comment;
    protected byte[] fileContent;
    private Text textFileName;
    private LabeledText textComments;
    private Button browseButton;

    public CreateNewCertificateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateNewCertificateDialog_CreateNewCertificateDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.textFileName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.CreateNewCertificateDialog_FileNameLabel, null, (Object)"WidgetHelper::default_layout_data");
        this.browseButton = new Button(dialogArea, 8);
        Messages.get();
        this.browseButton.setText(Messages.CreateNewCertificateDialog_BrowseLabel);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 90;
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(CreateNewCertificateDialog.this.getShell(), 4096);
                Messages.get();
                fd.setText(Messages.CreateNewCertificateDialog_SelectFileHeader);
                fd.setFilterExtensions(new String[]{"*.*"});
                String[] stringArray = new String[1];
                Messages.get();
                stringArray[0] = Messages.CreateNewCertificateDialog_All;
                fd.setFilterNames(stringArray);
                String selected = fd.open();
                if (selected != null) {
                    CreateNewCertificateDialog.this.textFileName.setText(selected);
                }
            }
        });
        this.textComments = new LabeledText(dialogArea, 2);
        Messages.get();
        this.textComments.setLabel(Messages.CreateNewCertificateDialog_CertificateCommentLabel);
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 4;
        gdText.horizontalSpan = 2;
        gdText.grabExcessHorizontalSpace = true;
        this.textComments.setLayoutData((Object)gdText);
        return dialogArea;
    }

    protected void okPressed() {
        this.comment = this.textComments.getText();
        String fName = this.textFileName.getText();
        try {
            this.fileContent = this.readFile(fName);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public byte[] readFile(String filename) throws CertificateException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(bis);
        return cert.getEncoded();
    }

    public String getComment() {
        return this.comment;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }
}

