/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serviceview.widgets.helpers;

import java.util.ArrayList;
import java.util.List;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.ServiceTreeElement;

public class ServiceTreeModel {
    private AbstractObject root;
    private List<ServiceTreeElement> elements = new ArrayList<ServiceTreeElement>();

    public ServiceTreeModel(AbstractObject root) {
        this.root = root;
        this.addToModel(null, root, 0);
    }

    private void addToModel(ServiceTreeElement parent, AbstractObject object, int level) {
        ServiceTreeElement element = new ServiceTreeElement(parent, object);
        this.elements.add(element);
        AbstractObject[] abstractObjectArray = object.getChildrenAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject o = abstractObjectArray[n2];
            if (o instanceof Container || o instanceof Node || o instanceof Cluster || o instanceof Condition) {
                this.addToModel(element, o, level + 1);
            }
            ++n2;
        }
    }

    public ServiceTreeElement[] getVisibleElements() {
        ArrayList<ServiceTreeElement> list = new ArrayList<ServiceTreeElement>(this.elements.size());
        for (ServiceTreeElement e : this.elements) {
            if (e.getParent() != null && !e.getParent().isExpanded()) continue;
            list.add(e);
        }
        return list.toArray(new ServiceTreeElement[list.size()]);
    }

    public AbstractObject getRoot() {
        return this.root;
    }
}

