/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ObjectStatusRadialWidget
extends Canvas
implements PaintListener,
DisposeListener {
    private AbstractObject rootObject;
    private int maxLvl;
    private int leafObjectCount;
    private float leafObjectSize;
    private int diameter;
    private int centerX;
    private int centerY;
    private ColorCache cCache;
    private Map<Long, ObjectData> objects;
    protected Image chartImage = null;
    private List<Integer> fontSize;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", "Verdana", "Arial"};
    private Font[] valueFonts;
    private static final int FONT_BASE_SIZE = 7;
    private static final int PADDING_HORIZONTAL = 6;
    private static final int PADDING_VERTICAL = 6;
    private static final int MARGIN = 6;
    private static final int SHIFT = 3;
    private boolean fitToScreen = true;
    private boolean needRender = false;
    private List<ObjectPosition> objectMap = new ArrayList<ObjectPosition>();

    public ObjectStatusRadialWidget(Composite parent, AbstractObject rootObject, Collection<AbstractObject> objects) {
        super(parent, 4);
        this.rootObject = rootObject;
        this.cCache = new ColorCache((Control)this);
        this.valueFonts = FontTools.getFonts((String[])FONT_NAMES, (int)7, (int)1, (int)16);
        this.objects = new HashMap<Long, ObjectData>();
        if (objects != null) {
            for (AbstractObject o : objects) {
                this.objects.put(o.getObjectId(), new ObjectData(o));
            }
        }
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addPaintListener(this);
        this.addDisposeListener(this);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ObjectStatusRadialWidget.this.refresh();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public void refresh() {
        if (this.rootObject == null) {
            return;
        }
        this.needRender = true;
        this.redraw();
    }

    private void render() {
        if (this.chartImage != null) {
            this.chartImage.dispose();
            this.chartImage = null;
        }
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        this.chartImage = new Image((Device)this.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.chartImage);
        this.paint(gc);
        gc.dispose();
    }

    private float drawParts(GC gc, AbstractObject object, int lvl, float degree) {
        gc.setAlpha(255);
        float objectSize = 0.0f;
        AbstractObject[] abstractObjectArray = object.getChildrenAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block18: {
                int lineNum;
                float currObjsize;
                AbstractObject obj;
                block17: {
                    block16: {
                        obj = abstractObjectArray[n2];
                        currObjsize = 0.0f;
                        if (!AbstractObjectStatusMap.isContainerObject(obj)) break block16;
                        currObjsize = this.drawParts(gc, obj, lvl + 1, degree);
                        if (currObjsize != 0.0f) break block17;
                        if (this.objects != null) break block18;
                        currObjsize = this.leafObjectSize;
                        break block17;
                    }
                    if (this.objects != null && !this.objects.containsKey(obj.getObjectId())) break block18;
                    currObjsize = this.leafObjectSize;
                }
                int compensation = Integer.signum(Math.round(degree + currObjsize) - (Math.round(degree) + Math.round(currObjsize)));
                if ((int)degree == 0 && (int)currObjsize == 360) {
                    gc.setBackground(this.getDisplay().getSystemColor(1));
                    gc.fillOval(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6);
                    gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                    gc.fillOval(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl);
                } else {
                    gc.setBackground(this.getDisplay().getSystemColor(1));
                    gc.fillArc(this.centerX - this.diameter * lvl / 2 - 3, this.centerY - this.diameter * lvl / 2 - 3, this.diameter * lvl + 6, this.diameter * lvl + 6, Math.round(degree), Math.round(currObjsize) + compensation);
                    gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()));
                    gc.fillArc(this.centerX - this.diameter * lvl / 2, this.centerY - this.diameter * lvl / 2, this.diameter * lvl, this.diameter * lvl, Math.round(degree), Math.round(currObjsize) - 1 + compensation);
                }
                this.objectMap.add(new ObjectPosition(degree, degree + currObjsize, lvl, obj));
                Transform oldTransform = new Transform(gc.getDevice());
                gc.getTransform(oldTransform);
                String text = obj.getObjectName();
                Transform tr = new Transform((Device)this.getDisplay());
                tr.translate((float)this.centerX, (float)this.centerY);
                float rotate = 0.0f;
                float middle = degree + currObjsize / 2.0f;
                if (middle >= 90.0f && middle < 180.0f) {
                    rotate = 90.0f - (middle - 90.0f);
                }
                if (middle >= 270.0f && middle <= 360.0f) {
                    rotate = 90.0f - (middle - 270.0f);
                }
                if (middle >= 0.0f && middle < 90.0f) {
                    rotate = -middle;
                }
                if (middle > 180.0f && middle < 270.0f) {
                    rotate = -(middle - 180.0f);
                }
                tr.rotate(rotate);
                gc.setTransform(tr);
                gc.setFont(this.valueFonts[this.fontSize.get(lvl - 1)]);
                int l = gc.textExtent((String)text, (int)3).x;
                int h = gc.textExtent((String)text, (int)3).y;
                if (currObjsize < 360.0f) {
                    int sectorHeight = (int)(Math.tan(Math.toRadians(currObjsize / 2.0f)) * (double)(this.diameter / 2 * (lvl - 1)) * 2.0) - 12;
                    lineNum = sectorHeight / h;
                    if (lineNum < 0 || lineNum > 3) {
                        lineNum = 3;
                    }
                } else {
                    lineNum = 3;
                }
                text = WidgetHelper.splitStringToLines((GC)gc, (String)text, (int)(this.diameter / 2 - 12), (int)lineNum).getResult();
                h = gc.textExtent((String)text, (int)3).y;
                gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)obj.getStatus()), (ColorCache)this.cCache));
                if (middle >= 90.0f && middle <= 180.0f || middle > 180.0f && middle < 270.0f) {
                    l = gc.textExtent((String)text, (int)3).x;
                    gc.drawText(text, -(this.diameter * (lvl - 1)) / 2 - 6 - l - 3, -h / 2, 3);
                } else {
                    gc.drawText(text, this.diameter * (lvl - 1) / 2 + 6 + 3, -h / 2, 3);
                }
                gc.setTransform(oldTransform);
                tr.dispose();
                oldTransform.dispose();
                degree += currObjsize;
                objectSize += currObjsize;
            }
            ++n2;
        }
        return objectSize;
    }

    private int calculateMaxLVLAndObjCount(AbstractObject object, int lvl) {
        AbstractObject[] objSet;
        int objectCount = 0;
        int foundObjectsCount = 0;
        AbstractObject[] abstractObjectArray = objSet = object.getChildrenAsArray();
        int n = objSet.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject obj = abstractObjectArray[n2];
            if (this.objects != null) {
                if (AbstractObjectStatusMap.isContainerObject(obj)) {
                    int tmp = this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                    if (tmp > 0) {
                        ++foundObjectsCount;
                        objectCount += tmp;
                    }
                } else if (this.objects.containsKey(obj.getObjectId())) {
                    ++objectCount;
                }
            } else if (AbstractObjectStatusMap.isContainerObject(obj)) {
                objectCount += this.calculateMaxLVLAndObjCount(obj, lvl + 1);
                ++foundObjectsCount;
            } else {
                ++objectCount;
            }
            ++n2;
        }
        if (this.objects == null && AbstractObjectStatusMap.isContainerObject(object) && objectCount == 0) {
            ++objectCount;
        }
        if (foundObjectsCount == 0 && this.maxLvl < lvl) {
            this.maxLvl = lvl;
        }
        return objectCount;
    }

    private int calculateLayerSize(AbstractObject object, int lvl, GC gc) {
        int objCount = 0;
        AbstractObject[] objSet = object.getChildrenAsArray();
        gc.setFont(this.valueFonts[0]);
        AbstractObject[] abstractObjectArray = objSet;
        int n = objSet.length;
        int n2 = 0;
        while (n2 < n) {
            int contSize;
            AbstractObject obj = abstractObjectArray[n2];
            if (AbstractObjectStatusMap.isContainerObject(obj)) {
                contSize = this.calculateLayerSize(obj, lvl + 1, gc);
                objCount += contSize;
            } else {
                contSize = 1;
                ++objCount;
            }
            this.calculateOptimalDiameter(obj, lvl, contSize, gc);
            ++n2;
        }
        if (objSet.length == 0) {
            ++objCount;
        }
        return objCount;
    }

    private void calculateOptimalDiameter(AbstractObject obj, int lvl, int objCount, GC gc) {
        String text = obj.getObjectName();
        int sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * lvl / 2) * 2.0) - 12;
        if (sectorHeight <= 0) {
            sectorHeight = 1286;
        }
        while (!WidgetHelper.fitToRect((GC)gc, (String)text, (int)(this.diameter / 2 - 12), (int)sectorHeight, (int)3)) {
            this.diameter = (int)((double)this.diameter + (double)this.diameter * 0.01);
            sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * lvl / 2) * 2.0) - 12;
            if (sectorHeight >= 0) continue;
            sectorHeight = 1286;
        }
    }

    private int calculateLayerFontSize(AbstractObject object, int lvl, GC gc) {
        AbstractObject[] objSet;
        int objCount = 0;
        AbstractObject[] abstractObjectArray = objSet = object.getChildrenAsArray();
        int n = objSet.length;
        int n2 = 0;
        while (n2 < n) {
            int contSize;
            AbstractObject obj = abstractObjectArray[n2];
            if (AbstractObjectStatusMap.isContainerObject(obj)) {
                contSize = this.calculateLayerFontSize(obj, lvl + 1, gc);
                objCount += contSize;
            } else {
                contSize = 1;
                ++objCount;
            }
            Integer optimalFontSie = this.calculateOptimalFontsie(obj, lvl, contSize, gc);
            if (this.fontSize.get(lvl) > optimalFontSie) {
                this.fontSize.set(lvl, optimalFontSie);
            }
            ++n2;
        }
        if (objSet.length == 0) {
            ++objCount;
        }
        return objCount;
    }

    private Integer calculateOptimalFontsie(AbstractObject obj, int lvl, int objCount, GC gc) {
        String text = obj.getObjectName();
        int sectorHeight = (int)(Math.tan(Math.toRadians(this.leafObjectSize * (float)objCount / 2.0f)) * (double)(this.diameter * lvl / 2) * 2.0) - 12;
        if (sectorHeight < 0) {
            sectorHeight = 1286;
        }
        int font = WidgetHelper.getBestFittingFontMultiline((GC)gc, (Font[])this.valueFonts, (String)text, (int)(this.diameter / 2 - 12), (int)sectorHeight, (int)3);
        return new Integer(font);
    }

    public void paintControl(PaintEvent e) {
        if (this.needRender) {
            this.render();
            this.needRender = false;
        }
        if (this.chartImage != null) {
            e.gc.drawImage(this.chartImage, 0, 0);
        }
    }

    public void recalculateData(GC gc) {
        this.leafObjectCount = this.calculateMaxLVLAndObjCount(this.rootObject, 1);
        this.diameter = 200;
        this.leafObjectSize = 360.0f / (float)this.leafObjectCount;
        if (!this.fitToScreen) {
            this.calculateLayerSize(this.rootObject, 1, gc);
        }
    }

    public void paint(GC gc) {
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            gc.drawText("Advanced graphics not supported", 30, 30, true);
            return;
        }
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setForeground(ThemeEngine.getForegroundColor((String)"StatusMap.Text"));
        gc.setLineWidth(1);
        this.objectMap.clear();
        this.recalculateData(gc);
        Rectangle rect = this.getClientArea();
        --rect.width;
        --rect.height;
        int rectSide = Math.min(rect.width, rect.height);
        this.diameter = Math.max(this.diameter, rectSide / (this.maxLvl + 1));
        this.centerX = rect.x + rectSide / 2;
        this.centerY = rect.y + rectSide / 2;
        this.fontSize = new ArrayList<Integer>(Collections.nCopies(this.maxLvl + 1, new Integer(100)));
        int squareSide = (int)((double)this.diameter / Math.sqrt(2.0));
        this.fontSize.set(0, new Integer(WidgetHelper.getBestFittingFontMultiline((GC)gc, (Font[])this.valueFonts, (String)this.rootObject.getObjectName(), (int)squareSide, (int)squareSide, (int)3)));
        this.calculateLayerFontSize(this.rootObject, 1, gc);
        Integer prevLVL = 100;
        int i = 0;
        while (i < this.fontSize.size()) {
            if (prevLVL < this.fontSize.get(i)) {
                this.fontSize.set(i, prevLVL);
            }
            prevLVL = this.fontSize.get(i);
            ++i;
        }
        this.drawParts(gc, this.rootObject, 2, 0.0f);
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2 - 3, this.centerY - this.diameter / 2 - 3, this.diameter + 6, this.diameter + 6);
        gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()));
        gc.setAlpha(255);
        gc.fillOval(this.centerX - this.diameter / 2, this.centerY - this.diameter / 2, this.diameter, this.diameter);
        String text = this.rootObject instanceof AbstractNode ? String.valueOf(this.rootObject.getObjectName()) + "\n" + ((AbstractNode)this.rootObject).getPrimaryIP().getHostAddress() : this.rootObject.getObjectName();
        gc.setFont(this.valueFonts[this.fontSize.get(0)]);
        gc.setClipping(rect);
        int h = gc.textExtent((String)text, (int)3).y;
        int l = gc.textExtent((String)text, (int)3).x;
        if (l + 6 >= this.diameter) {
            text = WidgetHelper.splitStringToLines((GC)gc, (String)text, (int)squareSide, (int)(squareSide / h)).getResult();
            h = gc.textExtent((String)text, (int)3).y;
            l = gc.textExtent((String)text, (int)3).x;
        }
        gc.setForeground(ColorConverter.selectTextColorByBackgroundColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)this.rootObject.getStatus()), (ColorCache)this.cCache));
        gc.drawText(text, this.centerX - l / 2, this.centerY - h / 2, 3);
        this.objectMap.add(new ObjectPosition(0.0f, 360.0f, 1, this.rootObject));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.rootObject == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        GC gc = new GC((Drawable)this.getDisplay());
        this.fitToScreen = wHint != -1 || hHint != -1;
        this.recalculateData(gc);
        gc.dispose();
        return this.fitToScreen ? new Point(Math.max(wHint, 240 * this.maxLvl), Math.max(hHint, 240 * this.maxLvl)) : new Point(this.diameter * (this.maxLvl + 1), this.diameter * (this.maxLvl + 1));
    }

    protected void updateObjects(AbstractObject rootObject, Collection<AbstractObject> objects) {
        this.rootObject = rootObject;
        this.objects.clear();
        for (AbstractObject o : objects) {
            this.objects.put(o.getObjectId(), new ObjectData(o));
        }
        this.needRender = true;
        this.redraw();
    }

    protected boolean containsObject(long id) {
        return this.rootObject.getObjectId() == id || this.objects.containsKey(id);
    }

    protected boolean containsChangedObject(AbstractObject object) {
        if (this.rootObject.getObjectId() == object.getObjectId()) {
            return true;
        }
        ObjectData d = this.objects.get(object.getObjectId());
        return d != null ? d.isChanged(object) : false;
    }

    public AbstractObject getObjectFromPoint(int x, int y) {
        AbstractObject object = null;
        int clickLvl = (int)(Math.sqrt(Math.pow(x - this.centerX, 2.0) + Math.pow(y - this.centerY, 2.0)) / (double)(this.diameter / 2) + 1.0);
        double clickDegree = Math.toDegrees(Math.atan2(this.centerX - x, this.centerY - y));
        if ((clickDegree += 90.0) < 0.0) {
            clickDegree += 360.0;
        }
        ObjectPosition curr = new ObjectPosition((float)clickDegree, (float)clickDegree, clickLvl, null);
        for (ObjectPosition p : this.objectMap) {
            if (!p.equals(curr)) continue;
            object = p.getObject();
            break;
        }
        return object;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
    }

    private class ObjectData {
        private String name;
        private ObjectStatus status;
        private long[] children;

        public ObjectData(AbstractObject object) {
            this.name = object.getObjectName();
            this.status = object.getStatus();
            this.children = AbstractObjectStatusMap.isContainerObject(object) ? object.getChildIdList() : null;
        }

        public boolean isChanged(AbstractObject object) {
            return this.status != object.getStatus() || !this.name.equals(object.getObjectName()) || AbstractObjectStatusMap.isContainerObject(object) && !Arrays.equals(this.children, object.getChildIdList());
        }
    }

    class ObjectPosition {
        float startDegree;
        float endDegree;
        int lvl;
        AbstractObject obj;

        public ObjectPosition(float startDegree, float endDegree, int lvl, AbstractObject obj) {
            this.startDegree = startDegree;
            this.endDegree = endDegree;
            this.lvl = lvl;
            this.obj = obj;
        }

        public AbstractObject getObject() {
            return this.obj;
        }

        public boolean equals(Object arg0) {
            if (((ObjectPosition)arg0).lvl != this.lvl) {
                return false;
            }
            return ((ObjectPosition)arg0).startDegree >= this.startDegree && ((ObjectPosition)arg0).endDegree <= this.endDegree;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.startDegree) + this.lvl;
        }
    }
}

