/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.TableCell;

public class TableRow {
    private List<TableCell> cells;
    private long objectId;
    private int baseRow;

    public TableRow(int rowCount) {
        this.objectId = 0L;
        this.baseRow = -1;
        this.cells = new ArrayList<TableCell>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.cells.add(new TableCell(""));
        }
    }

    public TableRow(TableRow src) {
        this.objectId = src.objectId;
        this.baseRow = src.baseRow;
        this.cells = new ArrayList<TableCell>(src.cells.size());
        for (int i = 0; i < src.cells.size(); ++i) {
            this.cells.add(new TableCell(src.get(i)));
        }
    }

    public TableCell get(int column) throws ArrayIndexOutOfBoundsException {
        return this.cells.get(column);
    }

    public String getValue(int column) {
        try {
            return this.cells.get(column).getValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public long getValueAsLong(int column) {
        try {
            return this.cells.get(column).getValueAsLong();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0L;
        }
    }

    public int getValueAsInteger(int column) {
        try {
            return this.cells.get(column).getValueAsInteger();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public double getValueAsDouble(int column) {
        try {
            return this.cells.get(column).getValueAsDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0.0;
        }
    }

    public int size() {
        return this.cells.size();
    }

    public long fillMessage(NXCPMessage msg, long baseId, boolean extendedFormat) {
        long varId = baseId;
        if (extendedFormat) {
            msg.setFieldInt32(varId++, (int)this.objectId);
            msg.setFieldInt32(varId++, this.baseRow);
            varId += 8L;
        }
        for (TableCell c : this.cells) {
            msg.setField(varId++, c.getValue());
            if (!extendedFormat) continue;
            msg.setFieldInt16(varId++, c.getStatus());
            msg.setFieldInt32(varId++, (int)c.getObjectId());
            varId += 7L;
        }
        return varId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getBaseRow() {
        return this.baseRow;
    }

    public void setBaseRow(int baseRow) {
        this.baseRow = baseRow;
    }

    public String toString() {
        return "TableRow{cells=" + this.cells + ", objectId=" + this.objectId + ", baseRow=" + this.baseRow + '}';
    }
}

