/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.product$next_exposer;
import org.python.modules.itertools.productDerived;

@ExposedType(name="itertools.product", base=PyObject.class, doc="product(*iterables) --> product object\n\nCartesian product of input iterables.  Equivalent to nested for-loops.\n\nFor example, product(A, B) returns the same as:  ((x,y) for x in A for y in B).\nThe leftmost iterators are in the outermost for-loop, so the output tuples\ncycle in a manner similar to an odometer (with the rightmost element changing\non every iteration).\n\nTo compute the product of an iterable with itself, specify the number\nof repetitions with the optional repeat keyword argument. For example,\nproduct(A, repeat=4) means the same as product(A, A, A, A).\n\nproduct('ab', range(3)) --> ('a',0) ('a',1) ('a',2) ('b',0) ('b',1) ('b',2)\nproduct((0,1), (0,1), (0,1)) --> (0,0,0) (0,0,1) (0,1,0) (0,1,1) (1,0,0) ...")
public class product
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String product_doc = "product(*iterables) --> product object\n\nCartesian product of input iterables.  Equivalent to nested for-loops.\n\nFor example, product(A, B) returns the same as:  ((x,y) for x in A for y in B).\nThe leftmost iterators are in the outermost for-loop, so the output tuples\ncycle in a manner similar to an odometer (with the rightmost element changing\non every iteration).\n\nTo compute the product of an iterable with itself, specify the number\nof repetitions with the optional repeat keyword argument. For example,\nproduct(A, repeat=4) means the same as product(A, A, A, A).\n\nproduct('ab', range(3)) --> ('a',0) ('a',1) ('a',2) ('b',0) ('b',1) ('b',2)\nproduct((0,1), (0,1), (0,1)) --> (0,0,0) (0,0,1) (0,1,0) (0,1,1) (1,0,0) ...";

    public product() {
    }

    public product(PyType subType) {
        super(subType);
    }

    public product(PyTuple[] tuples, int repeat2) {
        this.product___init__(tuples, repeat2);
    }

    @ExposedNew
    final void product___init__(PyObject[] args, String[] kws) {
        int num_iterables;
        int repeat2;
        if (kws.length == 1 && kws[0] == "repeat") {
            repeat2 = args[args.length - 1].asInt();
            if (repeat2 < 0) {
                throw Py.ValueError("repeat argument cannot be negative");
            }
            num_iterables = args.length - 1;
        } else {
            repeat2 = 1;
            num_iterables = args.length;
        }
        PyTuple[] tuples = new PyTuple[num_iterables];
        for (int i = 0; i < num_iterables; ++i) {
            tuples[i] = PyTuple.fromIterable(args[i]);
        }
        this.product___init__(tuples, repeat2);
    }

    private void product___init__(PyTuple[] tuples, int repeat2) {
        final int num_pools = tuples.length * repeat2;
        final PyTuple[] pools = new PyTuple[num_pools];
        for (int r = 0; r < repeat2; ++r) {
            System.arraycopy(tuples, 0, pools, r * tuples.length, tuples.length);
        }
        final int[] indices = new int[num_pools];
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                if (this.firstthru) {
                    for (PyTuple pool : pools) {
                        if (pool.__len__() != 0) continue;
                        return null;
                    }
                    this.firstthru = false;
                    return this.makeTuple();
                }
                for (int i = num_pools - 1; i >= 0; --i) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                    if (indices[i] != pools[i].__len__()) {
                        return this.makeTuple();
                    }
                    indices[i] = 0;
                }
                return null;
            }

            private PyTuple makeTuple() {
                PyObject[] items = new PyObject[num_pools];
                for (int i = 0; i < num_pools; ++i) {
                    items[i] = pools[i].__getitem__(indices[i]);
                }
                return new PyTuple(items);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(product.class, new product$PyExposer());
        TYPE = PyType.fromClass(product.class);
    }

    public class product$product___init___exposer
    extends PyBuiltinMethod {
        public product$product___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public product$product___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new product$product___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((product)this.self).product___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class product$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            product product2 = new product(this.for_type);
            if (bl) {
                product2.product___init__(pyObjectArray, stringArray);
            }
            return product2;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new productDerived(pyType);
        }
    }

    public class product$PyExposer
    extends BaseTypeBuilder {
        public product$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new product$product___init___exposer("__init__"), new product$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.product", product.class, PyObject.class, true, "product(*iterables) --> product object\n\nCartesian product of input iterables.  Equivalent to nested for-loops.\n\nFor example, product(A, B) returns the same as:  ((x,y) for x in A for y in B).\nThe leftmost iterators are in the outermost for-loop, so the output tuples\ncycle in a manner similar to an odometer (with the rightmost element changing\non every iteration).\n\nTo compute the product of an iterable with itself, specify the number\nof repetitions with the optional repeat keyword argument. For example,\nproduct(A, repeat=4) means the same as product(A, A, A, A).\n\nproduct('ab', range(3)) --> ('a',0) ('a',1) ('a',2) ('b',0) ('b',1) ('b',2)\nproduct((0,1), (0,1), (0,1)) --> (0,0,0) (0,0,1) (0,1,0) (0,1,1) (1,0,0) ...", pyBuiltinMethodArray, pyDataDescrArray, new product$exposed___new__());
        }
    }
}

