/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.VirtualizableFrame;
import net.sf.jasperreports.engine.type.BorderSplitType;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRBoxUtil;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    protected final JRLineBox lineBox;
    protected final BorderSplitType borderSplitType;
    private JRFillFrameElements frameContainer;
    private Map<JRStyle, JRTemplateElement> bottomTemplateFrames;
    private Map<JRStyle, JRTemplateElement> topTemplateFrames;
    private Map<JRStyle, JRTemplateElement> topBottomTemplateFrames;
    private boolean fillTopBorder;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller filler, JRFrame frame, JRFillObjectFactory factory) {
        super(filler, frame, factory);
        this.parentFrame = frame;
        this.lineBox = frame.getLineBox().clone(this);
        this.borderSplitType = this.initBorderSplitType(filler, frame);
        this.frameContainer = new JRFillFrameElements(factory);
        this.bottomTemplateFrames = new HashMap<JRStyle, JRTemplateElement>();
        this.topTemplateFrames = new HashMap<JRStyle, JRTemplateElement>();
        this.topBottomTemplateFrames = new HashMap<JRStyle, JRTemplateElement>();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame frame, JRFillCloneFactory factory) {
        super(frame, factory);
        this.parentFrame = frame.parentFrame;
        this.lineBox = frame.getLineBox().clone(this);
        this.borderSplitType = frame.borderSplitType;
        this.frameContainer = new JRFillFrameElements(frame.frameContainer, factory);
        this.bottomTemplateFrames = frame.bottomTemplateFrames;
        this.topTemplateFrames = frame.topTemplateFrames;
        this.topBottomTemplateFrames = frame.topBottomTemplateFrames;
    }

    private BorderSplitType initBorderSplitType(JRBaseFiller filler, JRFrame frame) {
        String splitTypeProp;
        BorderSplitType splitType = frame.getBorderSplitType();
        if (splitType == null && (splitTypeProp = filler.getPropertiesUtil().getProperty(filler.getJasperReport(), "net.sf.jasperreports.frame.border.split.type")) != null) {
            splitType = BorderSplitType.byName(splitTypeProp);
        }
        return splitType;
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.evaluateProperties(evaluation);
            this.evaluateStyle(evaluation);
            this.frameContainer.evaluate(evaluation);
            boolean repeating = true;
            JRFillElement[] elements = (JRFillElement[])this.getElements();
            for (int i = 0; repeating && i < elements.length; repeating &= elements[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(repeating);
        }
        this.filling = false;
    }

    @Override
    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    protected boolean drawTopBorderOnSplit() {
        return this.borderSplitType == BorderSplitType.DRAW_BORDERS;
    }

    protected boolean drawBotomBorderOnSplit() {
        return this.borderSplitType == BorderSplitType.DRAW_BORDERS;
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        boolean first = !isOverflow || !this.filling;
        int topPadding = this.getLineBox().getTopPadding();
        int bottomPadding = this.getLineBox().getBottomPadding();
        if (availableHeight < this.getRelativeY() + this.getHeight() - topPadding - bottomPadding) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && isOverflow && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        this.frameContainer.prepareElements(availableHeight - this.getRelativeY() - topPadding - bottomPadding, true);
        boolean willOverflow = this.frameContainer.willOverflow();
        this.fillTopBorder = first || this.drawTopBorderOnSplit();
        boolean bl = this.fillBottomBorder = !willOverflow || this.drawBotomBorderOnSplit();
        if (willOverflow) {
            this.setPrepareHeight(availableHeight - this.getRelativeY());
        } else {
            int neededStretch = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding;
            if (neededStretch <= availableHeight - this.getRelativeY()) {
                this.setPrepareHeight(neededStretch);
            } else {
                this.setPrepareHeight(availableHeight - this.getRelativeY());
            }
        }
        this.filling = willOverflow;
        return willOverflow;
    }

    @Override
    protected void setStretchHeight(int stretchHeight) {
        super.setStretchHeight(stretchHeight);
        int topPadding = this.getLineBox().getTopPadding();
        int bottomPadding = this.getLineBox().getBottomPadding();
        this.frameContainer.setStretchHeight(stretchHeight + this.frameContainer.getFirstY() - topPadding - bottomPadding);
    }

    @Override
    protected void stretchHeightFinal() {
        if (this.isToPrint()) {
            this.frameContainer.stretchElements();
            this.frameContainer.moveBandBottomElements();
            this.frameContainer.removeBlankElements();
            int topPadding = this.getLineBox().getTopPadding();
            int bottomPadding = this.getLineBox().getBottomPadding();
            super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding);
        }
    }

    @Override
    protected boolean stretchElementToHeight(int stretchHeight) {
        boolean applied = super.stretchElementToHeight(stretchHeight);
        if (applied) {
            this.frameContainer.stretchElementsToContainer();
            this.frameContainer.moveBandBottomElements();
        }
        return applied;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplate(), this.printElementOriginator);
        printFrame.setUUID(this.getUUID());
        printFrame.setX(this.getX());
        printFrame.setY(this.getRelativeY());
        printFrame.setWidth(this.getWidth());
        VirtualizableFrame virtualizableFrame = new VirtualizableFrame(printFrame, this.filler.getVirtualizationContext(), this.filler.getCurrentPage());
        this.frameContainer.fillElements(virtualizableFrame);
        virtualizableFrame.fill();
        printFrame.setHeight(this.getStretchHeight());
        this.transferProperties(printFrame);
        return printFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle style = this.getStyle();
        Map<JRStyle, JRTemplateElement> templatesMap = this.fillTopBorder ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame boxTemplate = (JRTemplateFrame)templatesMap.get(style);
        if (boxTemplate == null) {
            boxTemplate = this.createFrameTemplate();
            this.transferProperties(boxTemplate);
            if (this.fillTopBorder) {
                if (!this.fillBottomBorder) {
                    boxTemplate.copyBox(this.getLineBox());
                    JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, false, true);
                }
            } else if (this.fillBottomBorder) {
                boxTemplate.copyBox(this.getLineBox());
                JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, true, false);
            } else {
                boxTemplate.copyBox(this.getLineBox());
                JRBoxUtil.reset(boxTemplate.getLineBox(), false, false, true, true);
            }
            boxTemplate = this.filler.fillContext.deduplicate(boxTemplate);
            templatesMap.put(style, boxTemplate);
        }
        return boxTemplate;
    }

    protected JRTemplateFrame createFrameTemplate() {
        return new JRTemplateFrame(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return this.createFrameTemplate();
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    @Override
    public List<JRChild> getChildren() {
        return this.frameContainer.getChildren();
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public BorderSplitType getBorderSplitType() {
        return this.borderSplitType;
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.getChildren());
        }
    }

    @Override
    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillFrame(this, factory);
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory factory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, factory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements frameElements, JRFillCloneFactory factory) {
            super(frameElements, factory);
            this.initElements();
        }

        @Override
        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getLineBox().getTopPadding() - JRFillFrame.this.getLineBox().getBottomPadding();
        }

        @Override
        protected int getActualContainerHeight() {
            int containerHeight = JRFillFrame.this.getHeight() - JRFillFrame.this.getLineBox().getTopPadding() - JRFillFrame.this.getLineBox().getBottomPadding();
            if (((JRFillFrame)JRFillFrame.this).frameContainer.bottomElementInGroup != null && JRFillFrame.this.getLineBox().getTopPadding() + ((JRFillFrame)JRFillFrame.this).frameContainer.bottomElementInGroup.getY() + ((JRFillFrame)JRFillFrame.this).frameContainer.bottomElementInGroup.getHeight() > JRFillFrame.this.getHeight()) {
                containerHeight = ((JRFillFrame)JRFillFrame.this).frameContainer.bottomElementInGroup.getY() + ((JRFillFrame)JRFillFrame.this).frameContainer.bottomElementInGroup.getHeight();
            }
            return containerHeight;
        }

        @Override
        public boolean isSplitTypePreventInhibited(boolean isTopLevelCall) {
            return JRFillFrame.this.fillContainerContext.isSplitTypePreventInhibited(isTopLevelCall);
        }
    }
}

