/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.fill.OffsetElements;

public class OffsetElementsIterator
implements Iterator<JRPrintElement> {
    private final Iterator<Object> iterator;
    private OffsetElements subElements;
    private Iterator<? extends JRPrintElement> subIterator;

    public OffsetElementsIterator(List<Object> elements) {
        this.iterator = elements.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator != null && this.subIterator.hasNext() || this.iterator.hasNext();
    }

    @Override
    public JRPrintElement next() {
        JRPrintElement element = null;
        if (this.subIterator != null) {
            if (this.subIterator.hasNext()) {
                element = this.subIterator.next();
                this.subIterator.remove();
                this.setSubOffsets(element);
            } else {
                this.subIterator = null;
                this.subElements = null;
            }
        }
        if (element == null) {
            Object next = this.iterator.next();
            if (next instanceof JRPrintElement) {
                element = (JRPrintElement)next;
            } else {
                this.subElements = (OffsetElements)next;
                this.subIterator = this.subElements.getElements().iterator();
                element = this.subIterator.next();
                this.subIterator.remove();
                this.setSubOffsets(element);
            }
        }
        return element;
    }

    protected void setSubOffsets(JRPrintElement element) {
        element.setX(this.subElements.getOffsetX() + element.getX());
        element.setY(this.subElements.getOffsetY() + element.getY());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

