/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting;

import com.radensolutions.reporting.AutowiringSpringBeanJobFactory;
import com.radensolutions.reporting.dao.DaoContextConfig;
import com.radensolutions.reporting.service.ServerSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@ComponentScan(value={"com.radensolutions.reporting"})
@Import(value={DaoContextConfig.class})
public class AppContextConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AppContextConfig.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServerSettings settings;

    public void afterPropertiesSet() throws Exception {
        log.debug("AppContextConfig initialized.");
    }

    @Bean
    public JavaMailSender javaMailSender() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(this.settings.getSmtpServer());
        return sender;
    }

    @Bean
    public SchedulerFactoryBean quartzScheduler() {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        Properties mergedProperties = new Properties();
        mergedProperties.putAll((Map<?, ?>)this.loadProperties("org/quartz/quartz.properties"));
        ServerSettings.DataSourceConfig dataSourceConfig = this.settings.getDataSourceConfig("scheduler");
        Properties properties = new Properties();
        properties.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
        properties.put("org.quartz.jobStore.driverDelegateClass", dataSourceConfig.getQuartzDriverDelegate());
        properties.put("org.quartz.jobStore.dataSource", "myDS");
        properties.put("org.quartz.dataSource.myDS.driver", dataSourceConfig.getDriver());
        properties.put("org.quartz.dataSource.myDS.URL", dataSourceConfig.getUrl());
        properties.put("org.quartz.dataSource.myDS.user", dataSourceConfig.getUsername());
        properties.put("org.quartz.dataSource.myDS.password", dataSourceConfig.getPassword());
        properties.put("org.quartz.dataSource.myDS.maxConnections", "20");
        properties.put("org.quartz.scheduler.skipUpdateCheck", "true");
        mergedProperties.putAll((Map<?, ?>)properties);
        schedulerFactory.setQuartzProperties(mergedProperties);
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(this.applicationContext);
        schedulerFactory.setJobFactory((JobFactory)jobFactory);
        return schedulerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String name) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = classLoader.getResourceAsStream(name);
            properties.load(stream);
        }
        catch (Exception e) {
            log.error("Unable to load " + name, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

