/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class Container
extends GenericObject {
    private int flags;
    private boolean autoBind;
    private boolean autoUnbind;
    private String autoBindFilter;

    public Container(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.flags = msg.getFieldAsInt32(13L);
        this.autoBindFilter = msg.getFieldAsString(321L);
        this.autoBind = msg.getFieldAsBoolean(625L);
        this.autoUnbind = msg.getFieldAsBoolean(626L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public boolean isAutoBindEnabled() {
        return this.autoBind;
    }

    public boolean isAutoUnbindEnabled() {
        return this.autoUnbind;
    }

    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public String getObjectClassName() {
        return "Container";
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        Container.addString(strings, this.autoBindFilter);
        return strings;
    }
}

