/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpUsmCredential;

public class NetworkConfig {
    public static int NETWORK_CONFIG_GLOBAL = -1;
    public static int ALL_ZONES = -2;
    public static int COMMUNITIES = 1;
    public static int USM = 2;
    public static int PORTS = 4;
    public static int AGENT_SECRETS = 8;
    public static int ALL_CONFIGS = 15;
    private Map<Integer, List<String>> communities = new HashMap<Integer, List<String>>();
    private Map<Integer, List<SnmpUsmCredential>> usmCredentials = new HashMap<Integer, List<SnmpUsmCredential>>();
    private Map<Integer, List<Integer>> ports = new HashMap<Integer, List<Integer>>();
    private Map<Integer, List<String>> sharedSecrets = new HashMap<Integer, List<String>>();
    private NXCSession session;
    private Map<Integer, Integer> changedConfig = new HashMap<Integer, Integer>();

    public NetworkConfig(NXCSession session) {
        this.session = session;
    }

    public void load(int configId, int zoneUIN) throws NXCException, IOException {
        if ((configId & COMMUNITIES) > 0) {
            if (ALL_ZONES == zoneUIN) {
                this.communities = this.session.getSnmpCommunities();
            } else {
                this.communities.put(zoneUIN, this.session.getSnmpCommunities(zoneUIN));
            }
        }
        if ((configId & USM) > 0) {
            if (ALL_ZONES == zoneUIN) {
                this.usmCredentials = this.session.getSnmpUsmCredentials();
            } else {
                this.usmCredentials.put(zoneUIN, this.session.getSnmpUsmCredentials(zoneUIN));
            }
        }
        if ((configId & PORTS) > 0) {
            if (ALL_ZONES == zoneUIN) {
                this.ports = this.session.getSNMPPorts();
            } else {
                this.ports.put(zoneUIN, this.session.getSNMPPorts(zoneUIN));
            }
        }
        if ((configId & AGENT_SECRETS) > 0) {
            if (ALL_ZONES == zoneUIN) {
                this.sharedSecrets = this.session.getAgentSharedSecrets();
            } else {
                this.sharedSecrets.put(zoneUIN, this.session.getAgentSharedSecrets(zoneUIN));
            }
        }
    }

    public boolean isChanged(int configId, int zoneUIN) {
        return (this.changedConfig.getOrDefault(zoneUIN, 0) & configId) > 0;
    }

    public void save(NXCSession session) throws NXCException, IOException {
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & COMMUNITIES) <= 0) continue;
            session.updateSnmpCommunities(value.getKey().intValue(), this.communities.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & USM) <= 0) continue;
            session.updateSnmpUsmCredentials(value.getKey().intValue(), this.usmCredentials.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & PORTS) <= 0) continue;
            session.updateSNMPPorts(value.getKey().intValue(), this.ports.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & AGENT_SECRETS) <= 0) continue;
            session.updateAgentSharedSecrets(value.getKey().intValue(), this.sharedSecrets.get(value.getKey()));
        }
        this.changedConfig.clear();
    }

    public void setConfigUpdate(long zoneUIN, int id) {
        this.changedConfig.put((int)zoneUIN, this.changedConfig.getOrDefault((int)zoneUIN, 0) | id);
    }

    public List<String> getCommunities(long zoneUIN) {
        if (this.communities.containsKey((int)zoneUIN)) {
            return this.communities.get((int)zoneUIN);
        }
        return new ArrayList<String>();
    }

    public void addCommunityString(String communityString, long zoneUIN) {
        if (this.communities.containsKey((int)zoneUIN)) {
            this.communities.get((int)zoneUIN).add(communityString);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(communityString);
            this.communities.put((int)zoneUIN, list);
        }
    }

    public List<Integer> getPorts(long zoneUIN) {
        if (this.ports.containsKey((int)zoneUIN)) {
            return this.ports.get((int)zoneUIN);
        }
        return new ArrayList<Integer>();
    }

    public void addPort(Integer port, long zoneUIN) {
        if (this.ports.containsKey((int)zoneUIN)) {
            this.ports.get((int)zoneUIN).add(port);
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(port);
            this.ports.put((int)zoneUIN, list);
        }
    }

    public List<SnmpUsmCredential> getUsmCredentials(long zoneUIN) {
        if (this.usmCredentials.containsKey((int)zoneUIN)) {
            return this.usmCredentials.get((int)zoneUIN);
        }
        return new ArrayList<SnmpUsmCredential>();
    }

    public void addUsmCredentials(SnmpUsmCredential credential, long zoneUIN) {
        if (this.usmCredentials.containsKey((int)zoneUIN)) {
            this.usmCredentials.get((int)zoneUIN).add(credential);
        } else {
            ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>();
            list.add(credential);
            this.usmCredentials.put((int)zoneUIN, list);
        }
    }

    public List<String> getSharedSecrets(long zoneUIN) {
        if (this.sharedSecrets.containsKey((int)zoneUIN)) {
            return this.sharedSecrets.get((int)zoneUIN);
        }
        return new ArrayList<String>();
    }

    public void addSharedSecret(String sharedSecret, long zoneUIN) {
        if (this.sharedSecrets.containsKey((int)zoneUIN)) {
            this.sharedSecrets.get((int)zoneUIN).add(sharedSecret);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(sharedSecret);
            this.sharedSecrets.put((int)zoneUIN, list);
        }
    }
}

