/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFile;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRule;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="parser", strict=false)
public class LogParser {
    public static int PARSER_SYSLOG = 0;
    public static int PARSER_OTHER = 1;
    @Attribute(required=false)
    private String processALL = null;
    @Attribute(required=false)
    private Integer trace = null;
    @Attribute(required=false)
    private String name = null;
    @ElementList(required=false, entry="file", inline=true)
    private ArrayList<LogParserFile> file = new ArrayList(0);
    @ElementList(required=false)
    private ArrayList<LogParserRule> rules = new ArrayList(0);
    @ElementMap(entry="macro", key="name", attribute=true, required=false)
    private HashMap<String, String> macros = new HashMap(0);
    private int type;

    public static LogParser createFromXml(String xml) throws Exception {
        if (xml == null || xml.isEmpty()) {
            return new LogParser();
        }
        Persister serializer = new Persister();
        return (LogParser)serializer.read(LogParser.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public int getParserType() {
        return this.type;
    }

    public void setSyslogParser(int parserType) {
        this.type = parserType;
        if (this.type != 0) {
            this.file.clear();
        }
        for (LogParserRule rule : this.rules) {
            rule.updateFieldsCorrectly(this.type);
        }
    }

    public ArrayList<LogParserFile> getFiles() {
        return this.file;
    }

    public void setFiles(ArrayList<LogParserFile> files) {
        this.file = files;
    }

    public Integer getTrace() {
        return this.trace;
    }

    public void setTrace(Integer trace) {
        this.trace = trace;
    }

    public boolean getProcessALL() {
        return LogParser.stringToBoolean(this.processALL);
    }

    public void setProcessALL(boolean processALL) {
        this.processALL = LogParser.booleanToString(processALL);
    }

    public List<LogParserRule> getRules() {
        return this.rules;
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static boolean stringToBoolean(String value) {
        block4: {
            if (value != null) {
                try {
                    if (Integer.parseInt(value) != 0) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("yes")) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    public static String booleanToString(boolean value) {
        return value ? "true" : null;
    }

    public static String integerToString(Integer value) {
        return value == null ? "" : Integer.toString(value);
    }
}

