/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public class AbstractSelector
extends Composite {
    public static final int USE_HYPERLINK = 1;
    public static final int HIDE_LABEL = 2;
    public static final int USE_TEXT = 4;
    public static final int SHOW_CLEAR_BUTTON = 8;
    private Label label;
    private Control text;
    private Button selectionButton;
    private Button clearingButton;
    private ImageHyperlink selectionLink;
    private ImageHyperlink clearingLink;
    private Action actionCopy;
    private Image scaledImage = null;
    private Set<ModifyListener> modifyListeners = new HashSet<ModifyListener>(0);

    public AbstractSelector(Composite parent, int style, int options) {
        super(parent, style);
        GridData gd;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = (options & 8) != 0 ? 3 : 2;
        this.setLayout((Layout)layout);
        if ((options & 2) == 0) {
            this.label = new Label((Composite)this, 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = layout.numColumns;
            this.label.setLayoutData((Object)gd);
        }
        this.text = (options & 4) != 0 ? new Text((Composite)this, 2056) : new CLabel((Composite)this, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        if ((options & 1) != 0) {
            this.selectionLink = new ImageHyperlink((Composite)this, 0);
            gd = new GridData();
            gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
            this.selectionLink.setLayoutData((Object)gd);
            this.selectionLink.setImage(SharedIcons.IMG_FIND);
            this.selectionLink.setToolTipText(this.getSelectionButtonToolTip());
            this.selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AbstractSelector.this.selectionButtonHandler();
                }
            });
            if ((options & 8) != 0) {
                this.clearingLink = new ImageHyperlink((Composite)this, 0);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.clearingLink.setLayoutData((Object)gd);
                this.clearingLink.setImage(SharedIcons.IMG_CLEAR);
                this.clearingLink.setToolTipText(this.getClearingButtonToolTip());
                this.clearingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractSelector.this.clearButtonHandler();
                    }
                });
            }
        } else {
            this.selectionButton = new Button((Composite)this, 8);
            gd = new GridData();
            gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
            this.selectionButton.setLayoutData((Object)gd);
            this.selectionButton.setImage(SharedIcons.IMG_FIND);
            this.selectionButton.setToolTipText(this.getSelectionButtonToolTip());
            this.selectionButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractSelector.this.selectionButtonHandler();
                }
            });
            if ((options & 8) != 0) {
                this.clearingButton = new Button((Composite)this, 8);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.clearingButton.setLayoutData((Object)gd);
                this.clearingButton.setImage(SharedIcons.IMG_CLEAR);
                this.clearingButton.setToolTipText(this.getClearingButtonToolTip());
                this.clearingButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSelector.this.clearButtonHandler();
                    }
                });
            }
        }
        this.createActions();
        this.createContextMenu();
        this.text.setToolTipText(this.getTextToolTip());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSelector.this.scaledImage != null) {
                    AbstractSelector.this.scaledImage.dispose();
                }
            }
        });
    }

    private void createActions() {
        this.actionCopy = new Action(){

            public void run() {
                Clipboard cb = new Clipboard(AbstractSelector.this.getDisplay());
                cb.setContents(new Object[]{AbstractSelector.this.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        };
        Messages.get();
        this.actionCopy.setText(Messages.AbstractSelector_CopyToClipboard);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractSelector.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.text);
        this.text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionCopy);
    }

    protected void selectionButtonHandler() {
    }

    protected void clearButtonHandler() {
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.AbstractSelector_Select;
    }

    protected String getClearingButtonToolTip() {
        Messages.get();
        return Messages.AbstractSelector_ClearSelection;
    }

    protected String getTextToolTip() {
        return null;
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    protected void setText(String newText) {
        if (this.text instanceof CLabel) {
            ((CLabel)this.text).setText(newText);
        } else {
            ((Text)this.text).setText(newText);
        }
    }

    protected String getText() {
        if (this.text instanceof CLabel) {
            return ((CLabel)this.text).getText();
        }
        return ((Text)this.text).getText();
    }

    protected void setImage(Image image) {
        if (!(this.text instanceof CLabel)) {
            return;
        }
        if (this.scaledImage != null) {
            this.scaledImage.dispose();
            this.scaledImage = null;
        }
        if (image != null) {
            Rectangle size = image.getBounds();
            if (size.width > 64 || size.height > 64) {
                this.scaledImage = new Image((Device)this.getDisplay(), image.getImageData().scaledTo(64, 64));
                ((CLabel)this.text).setImage(this.scaledImage);
            } else {
                ((CLabel)this.text).setImage(image);
            }
        } else {
            ((CLabel)this.text).setImage(null);
        }
    }

    protected Image getImage() {
        if (this.text instanceof CLabel) {
            return ((CLabel)this.text).getImage();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        if (this.selectionButton != null) {
            this.selectionButton.setEnabled(enabled);
        }
        if (this.selectionLink != null) {
            this.selectionLink.setEnabled(enabled);
        }
        if (this.clearingButton != null) {
            this.clearingButton.setEnabled(enabled);
        }
        if (this.clearingLink != null) {
            this.clearingLink.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public Control getTextControl() {
        return this.text;
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    protected void fireModifyListeners() {
        if (this.modifyListeners.isEmpty()) {
            return;
        }
        Event e = new Event();
        e.display = this.getDisplay();
        e.doit = true;
        e.widget = this;
        ModifyEvent me = new ModifyEvent(e);
        for (ModifyListener l : this.modifyListeners) {
            l.modifyText(me);
        }
    }
}

