/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class AnimatedImage
extends Canvas
implements PaintListener,
DisposeListener {
    private GC memGC = null;
    private Image image = null;
    private ImageData[] imageData = null;
    private int imageNumber;
    private Runnable timer;

    public AnimatedImage(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(this);
        this.addDisposeListener(this);
        this.timer = new Runnable(){

            @Override
            public void run() {
                if (AnimatedImage.this.isDisposed() || AnimatedImage.this.imageData == null) {
                    return;
                }
                AnimatedImage animatedImage = AnimatedImage.this;
                animatedImage.imageNumber = animatedImage.imageNumber + 1;
                if (AnimatedImage.this.imageNumber == AnimatedImage.this.imageData.length) {
                    AnimatedImage.this.imageNumber = 0;
                }
                Image frameImage = new Image((Device)AnimatedImage.this.getDisplay(), AnimatedImage.this.imageData[AnimatedImage.this.imageNumber]);
                AnimatedImage.this.memGC.drawImage(frameImage, ((AnimatedImage)AnimatedImage.this).imageData[((AnimatedImage)AnimatedImage.this).imageNumber].x, ((AnimatedImage)AnimatedImage.this).imageData[((AnimatedImage)AnimatedImage.this).imageNumber].y);
                frameImage.dispose();
                AnimatedImage.this.redraw();
                AnimatedImage.this.scheduleAnimation();
            }
        };
    }

    public void setImage(URL url) {
        block16: {
            this.getDisplay().timerExec(-1, this.timer);
            if (this.memGC != null) {
                this.memGC.dispose();
                this.memGC = null;
            }
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            if (url == null) {
                this.imageData = null;
                return;
            }
            ImageLoader loader = new ImageLoader();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = url.openConnection().getInputStream();
                    this.imageData = loader.load(inputStream);
                    this.imageNumber = 0;
                    this.image = new Image((Device)this.getDisplay(), this.imageData[0]);
                    this.memGC = new GC((Drawable)this.image);
                    this.setSize(this.imageData[0].width, this.imageData[0].height);
                    this.redraw();
                    if (this.imageData.length > 1) {
                        this.scheduleAnimation();
                    }
                }
                catch (Exception e) {
                    this.imageData = null;
                    if (inputStream == null) break block16;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void scheduleAnimation() {
        if (this.imageData == null) {
            return;
        }
        this.getDisplay().timerExec(this.imageData[this.imageNumber].delayTime > 0 ? this.imageData[this.imageNumber].delayTime * 10 : 200, this.timer);
    }

    public void paintControl(PaintEvent e) {
        if (this.image != null) {
            e.gc.drawImage(this.image, 0, 0);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.imageData == null || this.imageData.length == 0) {
            return super.computeSize(wHint, hHint, changed);
        }
        int bw = this.getBorderWidth() * 2;
        return new Point(this.imageData[0].width + bw, this.imageData[0].height + bw);
    }
}

