/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.ui.eclipse.tools.ColorCache;

public class DashboardComposite
extends Canvas
implements PaintListener {
    protected ColorCache colors = new ColorCache((Control)this);
    private Color borderOuterColor = this.colors.create(171, 173, 179);
    private Color borderInnerColor = this.colors.create(255, 255, 255);
    private Color backgroundColor = this.colors.create(255, 255, 255);
    private boolean hasBorder = true;

    public DashboardComposite(Composite parent, int style) {
        super(parent, style & 0xFFFFF7FF);
        this.hasBorder = (style & 0x800) != 0;
        this.addPaintListener(this);
        this.setBackground(this.backgroundColor);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle trim = super.computeTrim(x, y, width, height);
        if (this.hasBorder) {
            trim.x -= 2;
            trim.y -= 2;
            trim.width += 4;
            trim.height += 4;
        }
        return trim;
    }

    public Rectangle getClientArea() {
        Rectangle area = super.getClientArea();
        if (this.hasBorder) {
            area.x += 2;
            area.y += 2;
            area.width -= 4;
            area.height -= 4;
        }
        return area;
    }

    public int getBorderWidth() {
        return this.hasBorder ? 2 : 0;
    }

    public void paintControl(PaintEvent e) {
        if (!this.hasBorder) {
            return;
        }
        Point size = this.getSize();
        Rectangle rect = new Rectangle(0, 0, size.x, size.y);
        --rect.width;
        --rect.height;
        e.gc.setForeground(this.borderOuterColor);
        e.gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 2, 2);
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        e.gc.setForeground(this.borderInnerColor);
        e.gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 2, 2);
    }

    protected Rectangle getFullClientArea() {
        return super.getClientArea();
    }

    protected Color getBorderOuterColor() {
        return this.borderOuterColor;
    }

    protected Color getBorderInnerColor() {
        return this.borderInnerColor;
    }
}

