/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.HostSearchResults;

public class FindConnectionPoint
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private List<AbstractObject> objects = null;

    public void run(IAction action) {
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.FindConnectionPoint_JobTitle, this.wbPart, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ConnectionPoint[] cps = new ConnectionPoint[FindConnectionPoint.this.objects.size()];
                int i = 0;
                while (i < FindConnectionPoint.this.objects.size()) {
                    AbstractObject object = (AbstractObject)FindConnectionPoint.this.objects.get(i);
                    cps[i] = session.findConnectionPoint(object.getObjectId());
                    if (cps[i] == null) {
                        cps[i] = object instanceof Node ? new ConnectionPoint(object.getObjectId(), 0L, false) : new ConnectionPoint(object.getParentIdList()[0], object.getObjectId(), false);
                    }
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (cps.length == 1) {
                            HostSearchResults.showConnection(cps[0]);
                        } else {
                            HostSearchResults.showConnection(cps);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.FindConnectionPoint_JobError;
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.objects = new ArrayList<AbstractObject>();
            for (Object s : ((IStructuredSelection)selection).toList()) {
                if (!(s instanceof Node) && !(s instanceof Interface) && !(s instanceof AccessPoint)) continue;
                action.setEnabled(true);
                this.objects.add((AbstractObject)s);
            }
        } else {
            action.setEnabled(false);
            this.objects = null;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }
}

