/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolExecutor;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.CommandBox;

public class Commands
extends OverviewPageElement {
    private CommandBox commandBox;
    private Action actionWakeup;

    public Commands(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
        this.createActions();
    }

    private void createActions() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        this.actionWakeup = new Action(Messages.Commands_ActionWakeup){

            public void run() {
                final AbstractObject object = Commands.this.getObject();
                Messages.get();
                new ConsoleJob(Messages.Commands_WakeupJobName, null, "org.netxms.ui.eclipse.objectview", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        session.wakeupNode(object.getObjectId());
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.Commands_WakeupJobError;
                    }
                }.start();
            }
        };
        this.actionWakeup.setImageDescriptor(Activator.getImageDescriptor("icons/wol.png"));
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Commands_Title;
    }

    @Override
    protected void onObjectChange() {
        this.commandBox.deleteAll(false);
        if (this.getObject() instanceof AbstractNode) {
            ObjectTool[] tools;
            ObjectTool[] objectToolArray = tools = ObjectToolsCache.getInstance().getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                final ObjectTool tool = objectToolArray[n2];
                if (tool.isVisibleInCommands() && tool.isEnabled() && tool.isApplicableForNode((AbstractNode)this.getObject())) {
                    final HashSet<ObjectContext> nodes = new HashSet<ObjectContext>(1);
                    nodes.add(new ObjectContext((AbstractNode)this.getObject(), null));
                    if (ObjectToolExecutor.isToolAllowed((ObjectTool)tool, nodes)) {
                        Action action = new Action(tool.getCommandDisplayName()){

                            public void run() {
                                ObjectToolExecutor.execute((Set)nodes, (ObjectTool)tool);
                            }
                        };
                        ImageDescriptor icon = ObjectToolsCache.getInstance().findIcon(tool.getId());
                        if (icon != null) {
                            action.setImageDescriptor(icon);
                        }
                        this.commandBox.add(action, false);
                    }
                }
                ++n2;
            }
        } else if (this.getObject() instanceof Interface) {
            this.commandBox.add(this.actionWakeup, false);
        }
        this.commandBox.rebuild();
    }

    @Override
    protected Control createClientArea(Composite parent) {
        this.commandBox = new CommandBox(parent, 0);
        return this.commandBox;
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Node || object instanceof Interface;
    }
}

