/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import java.util.Iterator;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.LoadingObject;
import org.netxms.client.objects.Node;

public class ObjectTreeContentProvider
extends TreeNodeContentProvider {
    private NXCSession session = null;
    private long[] rootObjects = null;
    private AbstractObject loadingObject;
    private boolean objectFullSync = false;

    public ObjectTreeContentProvider(long[] rootObjects, boolean objectFullSync) {
        this.objectFullSync = objectFullSync;
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        }
        this.loadingObject = new LoadingObject(-1L, this.session);
    }

    public Object[] getChildren(Object parentElement) {
        AbstractObject object = (AbstractObject)parentElement;
        if (!this.objectFullSync && object instanceof Node && object.hasChildren() && !this.session.areChildrenSynchronized(object.getObjectId())) {
            return new AbstractObject[]{this.loadingObject};
        }
        return object.getChildrenAsArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.session != null) {
            return this.rootObjects != null ? this.session.findMultipleObjects(this.rootObjects, false).toArray() : this.session.getTopLevelObjects();
        }
        return new AbstractObject[0];
    }

    public Object getParent(Object element) {
        if (this.session == null) {
            return null;
        }
        Iterator it = ((AbstractObject)element).getParents();
        return it.hasNext() ? this.session.findObjectById(((Long)it.next()).longValue()) : null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Node ? ((AbstractObject)element).hasChildren() : ((AbstractObject)element).hasAccessibleChildren();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.session = (NXCSession)newInput;
    }

    public void setRootObjects(long[] rootObjects) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        } else {
            this.rootObjects = null;
        }
    }
}

