/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objects.ObjectWrapper;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolExecutor;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ImageCache;

public class ObjectToolsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public ObjectToolsDynamicMenu() {
    }

    public ObjectToolsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        final Set<ObjectContext> nodes = this.buildNodeSet((IStructuredSelection)selection);
        Menu toolsMenu = new Menu(menu);
        final ImageCache imageCache = new ImageCache();
        toolsMenu.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                imageCache.dispose();
            }
        });
        ObjectTool[] tools = ObjectToolsCache.getInstance().getTools();
        Arrays.sort(tools, new Comparator<ObjectTool>(){

            @Override
            public int compare(ObjectTool arg0, ObjectTool arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tools.length) {
            boolean enabled;
            boolean bl = enabled = (tools[i].getFlags() & 4) == 0;
            if (enabled && ObjectToolExecutor.isToolAllowed(tools[i], nodes) && ObjectToolExecutor.isToolApplicable(tools[i], nodes)) {
                String[] path = tools[i].getName().split("\\-\\>");
                Menu rootMenu = toolsMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = String.valueOf(rootMenu.hashCode()) + "@" + path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                ImageDescriptor icon = ObjectToolsCache.getInstance().findIcon(tools[i].getId());
                if (icon != null) {
                    item.setImage(imageCache.add(icon));
                }
                item.setData((Object)tools[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ObjectToolExecutor.execute(nodes, (ObjectTool)item.getData());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem toolsMenuItem = new MenuItem(menu, 64, index);
            Messages.get();
            toolsMenuItem.setText(Messages.ObjectToolsDynamicMenu_TopLevelLabel);
            toolsMenuItem.setMenu(toolsMenu);
        } else {
            toolsMenu.dispose();
        }
    }

    private Set<ObjectContext> buildNodeSet(IStructuredSelection selection) {
        HashSet<ObjectContext> nodes = new HashSet<ObjectContext>();
        NXCSession session = ConsoleSharedData.getSession();
        for (Object o : selection.toList()) {
            AbstractObject n2;
            if (o instanceof AbstractNode) {
                nodes.add(new ObjectContext((AbstractNode)o, null));
                continue;
            }
            if (o instanceof Container || o instanceof ServiceRoot || o instanceof Subnet || o instanceof Cluster) {
                for (AbstractObject n2 : ((AbstractObject)o).getAllChildren(2)) {
                    nodes.add(new ObjectContext((AbstractNode)n2, null));
                }
                continue;
            }
            if (o instanceof Alarm) {
                n2 = (AbstractNode)session.findObjectById(((Alarm)o).getSourceObjectId(), AbstractNode.class);
                if (n2 == null) continue;
                nodes.add(new ObjectContext((AbstractNode)n2, (Alarm)o));
                continue;
            }
            if (!(o instanceof ObjectWrapper) || (n2 = ((ObjectWrapper)o).getObject()) == null || !(n2 instanceof AbstractNode)) continue;
            nodes.add(new ObjectContext((AbstractNode)n2, null));
        }
        return nodes;
    }
}

