/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerScriptResults
extends AbstractCommandResults
implements TextOutputListener {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ServerScriptResults";
    private IOConsoleOutputStream out;
    private String lastScript = null;
    private Action actionRestart;
    private Map<String, String> lastInputValues = null;
    private long alarmId;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                ServerScriptResults.this.executeScript(ServerScriptResults.this.lastScript, ServerScriptResults.this.alarmId, ServerScriptResults.this.lastInputValues);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeScript(final String script, final long alarmId, final Map<String, String> inputValues) {
        this.actionRestart.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        this.out = this.console.newOutputStream();
        this.lastScript = script;
        this.alarmId = alarmId;
        this.lastInputValues = inputValues;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, session.getObjectName(ServerScriptResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    session.executeLibraryScript(ServerScriptResults.this.nodeId, alarmId, script, inputValues, (TextOutputListener)ServerScriptResults.this);
                }
                finally {
                    if (ServerScriptResults.this.out != null) {
                        ServerScriptResults.this.out.close();
                        ServerScriptResults.this.out = null;
                    }
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerScriptResults.this.actionRestart.setEnabled(true);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
        super.dispose();
    }

    public void setStreamId(long streamId) {
    }

    public void onError() {
    }
}

