/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.AddUsmCredDialog;
import org.netxms.ui.eclipse.snmp.views.helpers.NetworkConfig;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpUsmLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NetworkCredentials
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.NetworkCredentials";
    public static final int USM_CRED_USER_NAME = 0;
    public static final int USM_CRED_AUTHENTICATION = 1;
    public static final int USM_CRED_ENCRYPTION = 2;
    public static final int USM_CRED_AUTH_PASSWORD = 3;
    public static final int USM_CRED_ENC_PASSWORD = 4;
    public static final int USM_CRED_COMMENTS = 5;
    private NXCSession session;
    private boolean modified = false;
    private boolean bothModified = false;
    private boolean saveInProgress = false;
    private CompositeWithMessageBar content;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TableViewer snmpCommunityList;
    private SortableTableViewer snmpUsmCredList;
    private TableViewer snmpPortList;
    private TableViewer sharedSecretList;
    private Action actionSave;
    private RefreshAction actionRefresh;
    private NetworkConfig config;
    private ZoneSelector zoneSelector;
    private Display display;
    private long zoneUIN = NetworkConfig.NETWORK_CONFIG_GLOBAL;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.config = new NetworkConfig(this.session);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.content = new CompositeWithMessageBar(parent, 0);
        this.toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        this.form = this.toolkit.createScrolledForm(this.content.getContent());
        Messages.get();
        this.form.setText(Messages.NetworkCredentials_FormTitle);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        if (this.session.isZoningEnabled()) {
            this.toolkit.decorateFormHeading(this.form.getForm());
            Composite headArea = this.toolkit.createComposite(this.form.getForm().getHead());
            headArea.setLayout((Layout)new GridLayout());
            this.zoneSelector = new ZoneSelector(headArea, 0, true);
            this.zoneSelector.setEmptySelectionText("Global");
            this.zoneSelector.setLabel("Select zone");
            GridData gd = new GridData();
            gd.widthHint = 300;
            this.zoneSelector.setLayoutData((Object)gd);
            this.form.setHeadClient((Control)headArea);
            this.zoneSelector.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NetworkCredentials.this.zoneUIN = NetworkCredentials.this.zoneSelector.getZoneUIN();
                    NetworkCredentials.this.updateFieldContent();
                }
            });
        }
        this.session.addListener(new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                int type = 0;
                switch (n.getCode()) {
                    case 1044: {
                        type = NetworkConfig.COMMUNITIES;
                        break;
                    }
                    case 1045: {
                        type = NetworkConfig.USM;
                        break;
                    }
                    case 1046: {
                        type = NetworkConfig.PORTS;
                        break;
                    }
                    case 1047: {
                        type = NetworkConfig.AGENT_SECRETS;
                    }
                }
                if (type != 0) {
                    final int configType = type;
                    NetworkCredentials.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!NetworkCredentials.this.config.isChanged(configType, (int)n.getSubCode())) {
                                NetworkCredentials.this.loadSnmpConfig(configType, (int)n.getSubCode());
                            } else if (!NetworkCredentials.this.saveInProgress) {
                                NetworkCredentials.this.content.showMessage(1, "Network credentials are modified by other users. \"Refresh\" will discard local changes. \"Save\" will overwrite other users changes with local changes.");
                                NetworkCredentials.this.bothModified = true;
                            }
                        }
                    });
                }
            }
        });
        this.createSnmpCommunitySection();
        this.createSnmpPortList();
        this.createSnmpUsmCredSection();
        this.createSharedSecretList();
        this.createActions();
        this.contributeToActionBars();
        this.loadSnmpConfig(NetworkConfig.ALL_CONFIGS, NetworkConfig.ALL_ZONES);
    }

    private void loadSnmpConfig(final int configId, final int zoneUIN) {
        Messages.get();
        new ConsoleJob(Messages.NetworkCredentials_LoadingConfig, (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkCredentials.this.config.load(configId, zoneUIN);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkCredentials.this.setConfig(NetworkCredentials.this.config);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorLoadingConfig;
            }
        }.start();
    }

    private void createActions() {
        Messages.get();
        this.actionSave = new Action(Messages.SnmpConfigurator_Save, SharedIcons.SAVE){

            public void run() {
                NetworkCredentials.this.save();
            }
        };
        this.actionRefresh = new RefreshAction(){

            public void run() {
                NetworkCredentials.this.hardRefresh();
            }
        };
    }

    private void hardRefresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Refresh network configuration", (String)"This will discard all unsaved changes. Do you really want to continue?")) {
            return;
        }
        this.loadSnmpConfig(NetworkConfig.ALL_CONFIGS, NetworkConfig.ALL_ZONES);
        this.modified = false;
        this.bothModified = false;
        this.firePropertyChange(257);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionRefresh);
    }

    private void createSnmpCommunitySection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.SnmpConfigurator_SectionCommunities);
        Messages.get();
        section.setDescription(Messages.SnmpConfigurator_SectionCommunitiesDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.snmpCommunityList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.snmpCommunityList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 4;
        gd.heightHint = 150;
        this.snmpCommunityList.getTable().setLayoutData((Object)gd);
        this.snmpCommunityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.addCommunity();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.removeCommunity();
            }
        });
        ImageHyperlink linkUp = this.toolkit.createImageHyperlink(clientArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveCommunity(true);
            }
        });
        ImageHyperlink linkDown = this.toolkit.createImageHyperlink(clientArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveCommunity(false);
            }
        });
    }

    private void createSnmpUsmCredSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.SnmpConfigurator_SectionUSM);
        Messages.get();
        section.setDescription(Messages.SnmpConfigurator_SectionUSMDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.colspan = 2;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        String[] names = new String[]{"User name", "Auth type", "Priv type", "Auth secret", "Priv secret", "Comments"};
        int[] widths = new int[]{100, 100, 100, 100, 100, 100};
        this.snmpUsmCredList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 67586);
        this.toolkit.adapt((Composite)this.snmpUsmCredList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 5;
        gd.heightHint = 150;
        this.snmpUsmCredList.getTable().setLayoutData((Object)gd);
        this.snmpUsmCredList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpUsmCredList.setLabelProvider((IBaseLabelProvider)new SnmpUsmLabelProvider());
        this.snmpUsmCredList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkCredentials.this.editUsmCredentials();
            }
        });
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.addUsmCredentials();
            }
        });
        ImageHyperlink linkEdit = this.toolkit.createImageHyperlink(clientArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.editUsmCredentials();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.removeUsmCredentials();
            }
        });
        ImageHyperlink linkUp = this.toolkit.createImageHyperlink(clientArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveUsmCredentials(true);
            }
        });
        ImageHyperlink linkDown = this.toolkit.createImageHyperlink(clientArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveUsmCredentials(false);
            }
        });
    }

    private void createSnmpPortList() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.NetworkCredentials_Ports);
        Messages.get();
        section.setDescription(Messages.NetworkCredentials_PortsDescription);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.snmpPortList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.snmpPortList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 4;
        gd.heightHint = 150;
        this.snmpPortList.getTable().setLayoutData((Object)gd);
        this.snmpPortList.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.addSnmpPort();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.removeSnmpPort();
            }
        });
        ImageHyperlink linkUp = this.toolkit.createImageHyperlink(clientArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveSnmpPort(true);
            }
        });
        ImageHyperlink linkDown = this.toolkit.createImageHyperlink(clientArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveSnmpPort(false);
            }
        });
    }

    private void createSharedSecretList() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        section.setText("Shared secrets");
        section.setDescription("Shared secrets used in the network");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.sharedSecretList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.sharedSecretList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 4;
        gd.heightHint = 150;
        this.sharedSecretList.getTable().setLayoutData((Object)gd);
        this.sharedSecretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.addSharedSecret();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.removeSharedSecret();
            }
        });
        ImageHyperlink linkUp = this.toolkit.createImageHyperlink(clientArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveSharedSecret(true);
            }
        });
        ImageHyperlink linkDown = this.toolkit.createImageHyperlink(clientArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentials.this.moveSharedSecret(false);
            }
        });
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void setConfig(NetworkConfig config) {
        this.config = config;
        this.updateFieldContent();
    }

    private void updateFieldContent() {
        this.snmpCommunityList.setInput(this.config.getCommunities(this.zoneUIN));
        this.snmpUsmCredList.setInput(this.config.getUsmCredentials(this.zoneUIN));
        this.snmpPortList.setInput(this.config.getPorts(this.zoneUIN));
        this.sharedSecretList.setInput(this.config.getSharedSecrets(this.zoneUIN));
    }

    private void setModified(int id) {
        this.config.setConfigUpdate(this.zoneUIN, id);
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.config.save(this.session);
        }
        catch (Exception e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.SnmpConfigurator_Error, (String)String.format(Messages.NetworkCredentials_CannotSaveConfig, e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void save() {
        if (this.bothModified && this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Save network credential", (String)"Network credentials already are modified by other users. Do you really want to continue and overwrite other users changes?\n")) {
                return;
            }
            this.content.hideMessage();
        }
        this.saveInProgress = true;
        Messages.get();
        new ConsoleJob(Messages.NetworkCredentials_SaveConfig, (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkCredentials.this.config.save(NetworkCredentials.this.session);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkCredentials.this.modified = false;
                        NetworkCredentials.this.bothModified = false;
                        NetworkCredentials.this.firePropertyChange(257);
                        NetworkCredentials.this.saveInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorSavingConfig;
            }

            protected void jobFinalize() {
                NetworkCredentials.this.saveInProgress = false;
            }
        }.start();
    }

    private void addCommunity() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.SnmpConfigurator_AddCommunity, Messages.SnmpConfigurator_AddCommunityDescr, "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            this.config.addCommunityString(s, this.zoneUIN);
            this.snmpCommunityList.setInput(this.config.getCommunities(this.zoneUIN));
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    private void removeCommunity() {
        List<String> list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpCommunityList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpCommunityList.setInput(list);
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    protected void moveCommunity(boolean up) {
        List<String> list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpCommunityList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpCommunityList.setInput(list);
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    private void addUsmCredentials() {
        AddUsmCredDialog dlg = new AddUsmCredDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getValue();
            cred.setZoneId((int)this.zoneUIN);
            this.config.addUsmCredentials(cred, this.zoneUIN);
            this.snmpUsmCredList.setInput(this.config.getUsmCredentials(this.zoneUIN));
            this.setModified(NetworkConfig.USM);
        }
    }

    private void editUsmCredentials() {
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpUsmCredential cred = (SnmpUsmCredential)selection.getFirstElement();
        AddUsmCredDialog dlg = new AddUsmCredDialog(this.getSite().getShell(), cred);
        if (dlg.open() == 0) {
            List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
            this.snmpUsmCredList.setInput((Object)list.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    private void removeUsmCredentials() {
        List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpUsmCredList.setInput((Object)list.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    protected void moveUsmCredentials(boolean up) {
        List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpUsmCredList.setInput(list);
            this.setModified(NetworkConfig.USM);
        }
    }

    private void addSnmpPort() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.NetworkCredentials_AddPort, Messages.NetworkCredentials_PleaseEnterPort, "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addPort(Integer.parseInt(value), this.zoneUIN);
            this.snmpPortList.setInput(this.config.getPorts(this.zoneUIN));
            this.setModified(NetworkConfig.PORTS);
        }
    }

    private void removeSnmpPort() {
        List<Integer> list = this.config.getPorts(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpPortList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove((Integer)o);
            }
            this.snmpPortList.setInput((Object)list.toArray());
            this.setModified(NetworkConfig.PORTS);
        }
    }

    protected void moveSnmpPort(boolean up) {
        List<Integer> list = this.config.getPorts(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.snmpPortList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf((Integer)o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpPortList.setInput(list);
            this.setModified(NetworkConfig.PORTS);
        }
    }

    protected void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Add shared secret", "Please enter shared secret", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addSharedSecret(value, this.zoneUIN);
            this.sharedSecretList.setInput(this.config.getSharedSecrets(this.zoneUIN));
            this.setModified(NetworkConfig.AGENT_SECRETS);
        }
    }

    protected void removeSharedSecret() {
        List<String> list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.sharedSecretList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.sharedSecretList.setInput((Object)list.toArray());
            this.setModified(NetworkConfig.AGENT_SECRETS);
        }
    }

    protected void moveSharedSecret(boolean up) {
        List<String> list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = (IStructuredSelection)this.sharedSecretList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.sharedSecretList.setInput(list);
            this.setModified(NetworkConfig.AGENT_SECRETS);
        }
    }
}

