/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateInterfaceDciDialog
extends Dialog {
    private static final String[] names;
    private static final String[] descriptions;
    private static final boolean[] DEFAULT_ENABLED;
    private Interface object;
    private InterfaceDciForm[] forms = new InterfaceDciForm[names.length];
    private LabeledText textInterval;
    private LabeledText textRetention;
    private int pollingInterval;
    private int retentionTime;
    private InterfaceDciInfo[] dciInfo;

    static {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.CreateInterfaceDciDialog_InBytes;
        Messages.get();
        stringArray[1] = Messages.CreateInterfaceDciDialog_OutBytes;
        Messages.get();
        stringArray[2] = Messages.CreateInterfaceDciDialog_InBits;
        Messages.get();
        stringArray[3] = Messages.CreateInterfaceDciDialog_OutBits;
        Messages.get();
        stringArray[4] = Messages.CreateInterfaceDciDialog_InPackets;
        Messages.get();
        stringArray[5] = Messages.CreateInterfaceDciDialog_OutPackets;
        Messages.get();
        stringArray[6] = Messages.CreateInterfaceDciDialog_InErrors;
        Messages.get();
        stringArray[7] = Messages.CreateInterfaceDciDialog_OutErrors;
        names = stringArray;
        String[] stringArray2 = new String[8];
        Messages.get();
        stringArray2[0] = Messages.CreateInterfaceDciDialog_InBytesDescr;
        Messages.get();
        stringArray2[1] = Messages.CreateInterfaceDciDialog_OutBytesDescr;
        Messages.get();
        stringArray2[2] = Messages.CreateInterfaceDciDialog_InBitsDescr;
        Messages.get();
        stringArray2[3] = Messages.CreateInterfaceDciDialog_OutBitsDescr;
        Messages.get();
        stringArray2[4] = Messages.CreateInterfaceDciDialog_InPacketsDescr;
        Messages.get();
        stringArray2[5] = Messages.CreateInterfaceDciDialog_OutPacketsDescr;
        Messages.get();
        stringArray2[6] = Messages.CreateInterfaceDciDialog_InErrorsDescr;
        Messages.get();
        stringArray2[7] = Messages.CreateInterfaceDciDialog_OutErrorsDescr;
        descriptions = stringArray2;
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        DEFAULT_ENABLED = blArray;
    }

    public CreateInterfaceDciDialog(Shell parentShell, Interface object) {
        super(parentShell);
        this.object = object;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateInterfaceDciDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        boolean[] enabled = new boolean[DEFAULT_ENABLED.length];
        int i = 0;
        while (i < enabled.length) {
            String v = settings.get("CreateInterfaceDciDialog.enabled_" + i);
            enabled[i] = v != null ? Boolean.parseBoolean(v) : DEFAULT_ENABLED[i];
            ++i;
        }
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        Group dataGroup = new Group(dialogArea, 0);
        Messages.get();
        dataGroup.setText(Messages.CreateInterfaceDciDialog_Data);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        dataGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        dataGroup.setLayout((Layout)layout);
        int i2 = 0;
        while (i2 < names.length) {
            if (i2 > 0) {
                Label sep = new Label((Composite)dataGroup, 258);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                sep.setLayoutData((Object)gd);
            }
            this.forms[i2] = new InterfaceDciForm((Composite)dataGroup, names[i2], this.object != null ? descriptions[i2].replaceAll("@@ifName@@", this.object.getObjectName()) : descriptions[i2], enabled[i2]);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.forms[i2].setLayoutData(gd);
            ++i2;
        }
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.CreateInterfaceDciDialog_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        this.textInterval = new LabeledText((Composite)optionsGroup, 0);
        Messages.get();
        this.textInterval.setLabel(Messages.CreateInterfaceDciDialog_PollingInterval);
        this.textInterval.getTextControl().setTextLimit(5);
        String v = settings.get("CreateInterfaceDciDialog.pollingInterval");
        this.textInterval.setText(v != null ? v : "60");
        this.textRetention = new LabeledText((Composite)optionsGroup, 0);
        Messages.get();
        this.textRetention.setLabel(Messages.CreateInterfaceDciDialog_RetentionTime);
        this.textRetention.getTextControl().setTextLimit(5);
        v = settings.get("CreateInterfaceDciDialog.retentionTime");
        this.textRetention.setText(v != null ? v : "30");
        return dialogArea;
    }

    protected void okPressed() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            this.pollingInterval = Integer.parseInt(this.textInterval.getText());
            if (this.pollingInterval < 2 || this.pollingInterval > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.CreateInterfaceDciDialog_Error, (String)Messages.CreateInterfaceDciDialog_BadPollingInterval);
        }
        try {
            this.retentionTime = Integer.parseInt(this.textRetention.getText());
            if (this.retentionTime < 1 || this.retentionTime > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.CreateInterfaceDciDialog_Error, (String)Messages.CreateInterfaceDciDialog_BadRetentionTime);
        }
        settings.put("CreateInterfaceDciDialog.pollingInterval", this.pollingInterval);
        settings.put("CreateInterfaceDciDialog.retentionTime", this.retentionTime);
        this.dciInfo = new InterfaceDciInfo[this.forms.length];
        int i = 0;
        while (i < this.forms.length) {
            this.dciInfo[i] = new InterfaceDciInfo(this.forms[i].isDciEnabled(), this.forms[i].isDelta(), this.forms[i].getDescription());
            settings.put("CreateInterfaceDciDialog.enabled_" + i, this.forms[i].isDciEnabled());
            settings.put("CreateInterfaceDciDialog.delta_" + i, this.forms[i].isDelta());
            settings.put("CreateInterfaceDciDialog.description_" + i, this.forms[i].getDescription());
            ++i;
        }
        super.okPressed();
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public InterfaceDciInfo[] getDciInfo() {
        return this.dciInfo;
    }

    private class InterfaceDciForm
    extends Composite {
        private Button checkEnable;
        private Button checkDelta;
        private Text description;

        public InterfaceDciForm(Composite parent, String name, String defaultDescription, boolean enabled) {
            super(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            Composite buttonRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonRow.setLayout((Layout)layout);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            buttonRow.setLayoutData((Object)gd);
            this.checkEnable = new Button(buttonRow, 32);
            this.checkEnable.setText(name);
            this.checkEnable.setSelection(enabled);
            this.checkDelta = new Button(buttonRow, 32);
            Messages.get();
            this.checkDelta.setText(Messages.CreateInterfaceDciDialog_Delta);
            this.checkDelta.setSelection(true);
            this.checkDelta.setEnabled(enabled);
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            this.checkDelta.setLayoutData((Object)gd);
            Composite textRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            textRow.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            textRow.setLayoutData((Object)gd);
            Label label = new Label(textRow, 0);
            Messages.get();
            label.setText(Messages.CreateInterfaceDciDialog_Description);
            this.description = new Text(textRow, 2048);
            this.description.setText(defaultDescription);
            this.description.setTextLimit(255);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.description.setLayoutData((Object)gd);
            this.description.setEnabled(enabled);
            this.checkEnable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = InterfaceDciForm.this.checkEnable.getSelection();
                    InterfaceDciForm.this.checkDelta.setEnabled(enabled);
                    InterfaceDciForm.this.description.setEnabled(enabled);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public boolean isDciEnabled() {
            return this.checkEnable.getSelection();
        }

        public boolean isDelta() {
            return this.checkDelta.getSelection();
        }

        public String getDescription() {
            return this.description.getText();
        }
    }
}

