/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.GraphFolder;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.propertypages.DataSources;
import org.netxms.ui.eclipse.perfview.propertypages.General;
import org.netxms.ui.eclipse.perfview.propertypages.Graph;
import org.netxms.ui.eclipse.perfview.views.HistoricalGraphView;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphTreeContentProvider;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphTreeFilter;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.FilterText;

public class PredefinedGraphTree
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.PredefinedGraphTree";
    private GraphFolder root = null;
    private TreeViewer viewer;
    private FilterText filterText;
    private boolean initShowFilter = true;
    private NXCSession session;
    private RefreshAction actionRefresh;
    private Action actionOpen;
    private Action actionProperties;
    private Action actionDelete;
    private Action actionShowFilter;
    private GraphTreeFilter filter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = PredefinedGraphTree.safeCast(settings.get("PredefinedGraphTree.showFilter"), settings.getBoolean("PredefinedGraphTree.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(parent, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedGraphTree.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                PredefinedGraphTree.this.enableFilter(false);
            }
        });
        this.viewer = new TreeViewer(parent, 0);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new GraphTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphTreeLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1 instanceof GraphFolder ? (e2 instanceof GraphFolder ? ((GraphFolder)e1).getDisplayName().compareToIgnoreCase(((GraphFolder)e2).getDisplayName()) : -1) : (e2 instanceof GraphSettings ? ((GraphSettings)e1).getDisplayName().compareToIgnoreCase(((GraphSettings)e2).getDisplayName()) : 1);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PredefinedGraphTree.this.actionOpen.run();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                Iterator it = selection.iterator();
                boolean enabled = false;
                while (it.hasNext()) {
                    if (!(it.next() instanceof GraphSettings)) continue;
                    enabled = true;
                    break;
                }
                PredefinedGraphTree.this.actionOpen.setEnabled(enabled);
                PredefinedGraphTree.this.actionDelete.setEnabled(enabled);
                PredefinedGraphTree.this.actionProperties.setEnabled(enabled);
            }
        });
        this.filter = new GraphTreeFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.reloadGraphList();
        this.session.addListener((SessionListener)this);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("PredefinedGraphTree.showFilter", this.initShowFilter);
        super.dispose();
    }

    public void setFocus() {
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.viewer.getTree().setFocus();
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PredefinedGraphTree.this.reloadGraphList();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.PredefinedGraphTree_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                PredefinedGraphTree.this.deletePredefinedGraph();
            }
        };
        this.actionOpen = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                for (Object o : selection) {
                    if (o instanceof GraphSettings) {
                        PredefinedGraphTree.this.showPredefinedGraph((GraphSettings)o);
                        continue;
                    }
                    if (!(o instanceof GraphFolder)) continue;
                    if (PredefinedGraphTree.this.viewer.getExpandedState(o)) {
                        PredefinedGraphTree.this.viewer.collapseToLevel(o, -1);
                        continue;
                    }
                    PredefinedGraphTree.this.viewer.expandToLevel(o, 1);
                }
            }
        };
        Messages.get();
        this.actionOpen.setText(Messages.PredefinedGraphTree_Open);
        Messages.get();
        this.actionProperties = new Action(Messages.PredefinedGraphTree_Properties){

            public void run() {
                PredefinedGraphTree.this.editPredefinedGraph();
            }
        };
        Messages.get();
        this.actionShowFilter = new Action(Messages.PredefinedGraphTree_ShowFilter, 2){

            public void run() {
                PredefinedGraphTree.this.enableFilter(!PredefinedGraphTree.this.initShowFilter);
                PredefinedGraphTree.this.actionShowFilter.setChecked(PredefinedGraphTree.this.initShowFilter);
            }
        };
        this.actionShowFilter.setId("org.netxms.ui.eclipse.perfview.actions.showFilter");
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.perfview.commands.show_graph_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.perfview.context.PredefinedGraphTree");
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PredefinedGraphTree.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof GraphFolder) {
            return;
        }
        mgr.add((IAction)this.actionOpen);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionProperties);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void reloadGraphList() {
        Messages.get();
        new ConsoleJob(Messages.PredefinedGraphTree_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PredefinedGraphTree_LoadJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final GraphFolder graphs = PredefinedGraphTree.this.session.getPredefinedGraphsAsTree();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PredefinedGraphTree.this.root = graphs;
                        PredefinedGraphTree.this.viewer.setInput((Object)PredefinedGraphTree.this.root);
                    }
                });
            }
        }.start();
    }

    private void showPredefinedGraph(GraphSettings gs) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(gs.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            encodedName = "___ERROR___";
        }
        String id = "org.netxms.ui.eclipse.charts.predefinedGraph&" + encodedName;
        try {
            HistoricalGraphView g = (HistoricalGraphView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
            if (g != null) {
                g.initPredefinedGraph(gs);
            }
        }
        catch (PartInitException e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.PredefinedGraphTree_Error, (String)String.format(Messages.PredefinedGraphTree_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void editPredefinedGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        GraphSettings settings = (GraphSettings)selection.getFirstElement();
        if (this.showGraphPropertyPages(settings)) {
            final GraphSettings newSettings = settings;
            try {
                Messages.get();
                new ConsoleJob(Messages.PredefinedGraphTree_UpdateJobName, null, "org.netxms.ui.eclipse.perfview", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        PredefinedGraphTree.this.session.saveGraph(newSettings, false);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                PredefinedGraphTree.this.viewer.update((Object)newSettings, null);
                            }
                        });
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.PredefinedGraphTree_UpdateJobError;
                    }
                }.start();
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Internal Error", (String)String.format("Unexpected exception: %s", e.getLocalizedMessage()));
            }
        }
    }

    private void deletePredefinedGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.PredefinedGraphTree_DeletePromptTitle, (String)Messages.PredefinedGraphTree_DeletePromptText)) {
            return;
        }
        for (final Object o : selection.toList()) {
            if (!(o instanceof GraphSettings)) continue;
            Messages.get();
            new ConsoleJob(String.format(Messages.PredefinedGraphTree_DeleteJobName, ((GraphSettings)o).getShortName()), null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    PredefinedGraphTree.this.session.deletePredefinedGraph(((GraphSettings)o).getId());
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.PredefinedGraphTree_DeleteJobError;
                }
            }.start();
        }
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1028: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PredefinedGraphTree.this.root.removeGraph(n.getSubCode())) {
                            PredefinedGraphTree.this.viewer.refresh();
                        }
                    }
                });
                break;
            }
            case 1012: {
                if (((GraphSettings)n.getObject()).isTemplate()) {
                    return;
                }
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphSettings element;
                        IStructuredSelection selection = (IStructuredSelection)PredefinedGraphTree.this.viewer.getSelection();
                        PredefinedGraphTree.this.root.updateGraph((GraphSettings)n.getObject());
                        PredefinedGraphTree.this.viewer.refresh();
                        if (selection.size() == 1 && selection.getFirstElement() instanceof GraphSettings && (element = (GraphSettings)selection.getFirstElement()).getId() == n.getSubCode()) {
                            PredefinedGraphTree.this.viewer.setSelection((ISelection)new StructuredSelection((Object)((GraphSettings)n.getObject())), true);
                        }
                    }
                });
            }
        }
    }

    private void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTree().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.filterText.getParent().layout(true, true);
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
        GraphSettings s = this.filter.getLastMatch();
        if (s != null) {
            this.viewer.expandToLevel((Object)s, 1);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)s), true);
        }
    }

    private boolean showGraphPropertyPages(final GraphSettings settings) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("graph", (IPreferencePage)new Graph(settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("source", (IPreferencePage)new DataSources(settings, true)));
        PreferenceDialog dlg = new PreferenceDialog(this.getViewSite().getShell(), pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Properties for " + settings.getDisplayName());
            }
        };
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }
}

