/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectQueryResult;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.helpers.ObjectDetailsLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.helpers.ObjectSelectionProvider;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectDetailsConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandlerRegistry;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectQuery
extends ElementWidget {
    private ObjectDetailsConfig config;
    private ViewRefreshController refreshController;
    private NXCSession session = ConsoleSharedData.getSession();
    private boolean updateInProgress = false;
    private SortableTableViewer viewer;
    private ObjectSelectionProvider objectSelectionProvider;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;

    public ObjectQuery(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = ObjectDetailsConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ObjectDetailsConfig();
        }
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectDetailsLabelProvider(this.config.getProperties()));
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (((SortableTableViewer)viewer).getTable().getSortColumn() == null) {
                    return 0;
                }
                ObjectDetailsConfig.ObjectProperty p = (ObjectDetailsConfig.ObjectProperty)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ObjectProperty");
                String v1 = ((ObjectQueryResult)e1).getPropertyValue(p.name);
                String v2 = ((ObjectQueryResult)e2).getPropertyValue(p.name);
                int result = 0;
                switch (p.type) {
                    case 1: {
                        result = Long.signum(ObjectQuery.safeParseLong(v1) - ObjectQuery.safeParseLong(v2));
                        break;
                    }
                    case 2: {
                        double d1 = ObjectQuery.safeParseDouble(v1);
                        double d2 = ObjectQuery.safeParseDouble(v2);
                        result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                        break;
                    }
                    default: {
                        result = v1.compareToIgnoreCase(v2);
                    }
                }
                return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
            }
        });
        for (ObjectDetailsConfig.ObjectProperty p : this.config.getProperties()) {
            TableColumn c = this.viewer.addColumn(p.displayName == null || p.displayName.isEmpty() ? p.name : p.displayName, 150);
            c.setData("ObjectProperty", (Object)p);
        }
        this.viewer.getTable().setSortDirection(128);
        if (this.viewer.getTable().getColumnCount() > 0) {
            this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(0));
        }
        this.objectSelectionProvider = new ObjectSelectionProvider((ISelectionProvider)this.viewer);
        this.createPopupMenu();
        this.viewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ObjectQuery.this.setSelectionProviderDelegate((ISelectionProvider)ObjectQuery.this.objectSelectionProvider);
            }
        });
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry(viewPart);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((IStructuredSelection)ObjectQuery.this.viewer.getSelection()).getFirstElement();
                if (o != null && o instanceof ObjectQueryResult) {
                    ObjectQuery.this.doubleClickHandlers.handleDoubleClick(((ObjectQueryResult)o).getObject());
                }
            }
        });
        this.refreshController = new ViewRefreshController(viewPart, this.config.getRefreshRate(), new Runnable(){

            @Override
            public void run() {
                if (ObjectQuery.this.isDisposed()) {
                    return;
                }
                ObjectQuery.this.refreshData();
            }
        });
        this.refreshData();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectQuery.this.refreshController.dispose();
            }
        });
    }

    static long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager(null, String.valueOf(this.viewPart.getViewSite().getId()) + "." + ((Object)((Object)this)).hashCode());
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectContextMenu.fill((IMenuManager)mgr, (IShellProvider)ObjectQuery.this.viewPart.getSite(), (ISelectionProvider)ObjectQuery.this.objectSelectionProvider);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewPart.getSite().registerContextMenu(menuManager.getId(), menuManager, (ISelectionProvider)this.objectSelectionProvider);
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Run object query", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List<ObjectDetailsConfig.ObjectProperty> properties = ObjectQuery.this.config.getProperties();
                ArrayList<String> names = new ArrayList<String>(properties.size());
                for (ObjectDetailsConfig.ObjectProperty p : properties) {
                    names.add(p.name);
                }
                final List objects = ObjectQuery.this.session.queryObjectDetails(ObjectQuery.this.config.getQuery(), names, ObjectQuery.this.config.getOrderingProperties(), ObjectQuery.this.config.getRecordLimit());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ObjectQuery.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        ObjectQuery.this.viewer.setInput((Object)objects);
                        ObjectQuery.this.viewer.packColumns();
                        ObjectQuery.this.updateInProgress = false;
                    }
                });
            }

            protected void jobFailureHandler() {
                ObjectQuery.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected String getErrorMessage() {
                return "Cannot execute object query";
            }
        };
        job.setUser(false);
        job.start();
    }
}

