/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;

public class TimestampFieldEditor
extends FieldEditor {
    private DateTime datePicker;
    private DateTime timePicker;
    private Type type;

    public TimestampFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
    }

    @Override
    protected Control createContent(Composite parent) {
        Date date;
        this.parseType();
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        area.setLayout((Layout)layout);
        try {
            date = new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L);
        }
        catch (NumberFormatException e) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.datePicker = new DateTime(area, 2084);
        this.toolkit.adapt((Composite)this.datePicker);
        this.datePicker.setDate(c.get(1), c.get(2), c.get(5));
        if (this.type == Type.TIMESTAMP) {
            this.timePicker = new DateTime(area, 2176);
            this.toolkit.adapt((Composite)this.timePicker);
            this.timePicker.setTime(c.get(11), c.get(12), c.get(13));
        }
        return area;
    }

    private void parseType() {
        String parameterType = this.parameter.getType();
        this.type = parameterType.equals("START_DATE") ? Type.START_DATE : (parameterType.equals("END_DATE") ? Type.END_DATE : Type.TIMESTAMP);
    }

    @Override
    public String getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        switch (this.type) {
            case START_DATE: {
                calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), 0, 0, 0);
                break;
            }
            case END_DATE: {
                calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), 23, 59, 59);
                break;
            }
            case TIMESTAMP: {
                calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), this.timePicker.getHours(), this.timePicker.getMinutes(), this.timePicker.getSeconds());
            }
        }
        return Long.toString(calendar.getTimeInMillis() / 1000L);
    }

    public static enum Type {
        START_DATE,
        END_DATE,
        TIMESTAMP;

    }
}

