/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicyComparator;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicyContentProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicyLabelProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.PathElement;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class FileDeliveryPolicyEditor
extends AbstractPolicyEditor {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_GUID = 1;
    public static final int COLUMN_DATE = 2;
    private SortableTreeViewer fileTree;
    private Set<PathElement> rootElements = new HashSet<PathElement>();
    private Action actionAddRoot;
    private Action actionAddDirectory;
    private Action actionAddFile;
    private Action actionDelete;
    private Action actionRename;
    private Action actionUpdate;
    private Set<String> filesForDeletion = new HashSet<String>();
    private Set<String> notSavedFiles = new HashSet<String>();

    public FileDeliveryPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style, policy, viewPart);
        this.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{"Name", "Guid", "Date"};
        int[] columnWidths = new int[]{300, 300, 300};
        this.fileTree = new SortableTreeViewer((Composite)this, columnNames, columnWidths, 0, 128, -1);
        this.fileTree.setContentProvider((IContentProvider)new FileDeliveryPolicyContentProvider());
        this.fileTree.setLabelProvider((IBaseLabelProvider)new FileDeliveryPolicyLabelProvider());
        this.fileTree.setComparator((ViewerComparator)new FileDeliveryPolicyComparator());
        this.actionAddRoot = new Action("&Add root directory...", SharedIcons.ADD_OBJECT){

            public void run() {
                FileDeliveryPolicyEditor.this.addElement(null);
            }
        };
        this.actionAddDirectory = new Action("Add d&irectory..."){

            public void run() {
                FileDeliveryPolicyEditor.this.addDirectory();
            }
        };
        this.actionAddFile = new Action("Add &file..."){

            public void run() {
                FileDeliveryPolicyEditor.this.addFile();
            }
        };
        this.actionRename = new Action("&Rename..."){

            public void run() {
                FileDeliveryPolicyEditor.this.renameElement();
            }
        };
        this.actionDelete = new Action("&Delete"){

            public void run() {
                FileDeliveryPolicyEditor.this.deleteElements();
            }
        };
        this.actionUpdate = new Action("&Update..."){

            public void run() {
                FileDeliveryPolicyEditor.this.updateFile();
            }
        };
        this.createPopupMenu();
        this.fileTree.setInput(this.rootElements);
        this.updateControlFromPolicy();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FileDeliveryPolicyEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fileTree.getControl());
        this.fileTree.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            manager.add((IAction)this.actionAddRoot);
        } else if (selection.size() == 1) {
            PathElement e = (PathElement)selection.getFirstElement();
            if (e.isFile()) {
                manager.add((IAction)this.actionUpdate);
            } else {
                manager.add((IAction)this.actionAddDirectory);
                manager.add((IAction)this.actionAddFile);
            }
            manager.add((IAction)this.actionRename);
            manager.add((IAction)this.actionDelete);
        } else {
            manager.add((IAction)this.actionDelete);
        }
    }

    @Override
    public void updateControlFromPolicy() {
        HashSet<PathElement> newElementSet = new HashSet<PathElement>();
        try {
            FileDeliveryPolicy policyData = FileDeliveryPolicy.createFromXml(this.getPolicy().getContent());
            newElementSet.addAll(Arrays.asList(policyData.elements));
        }
        catch (Exception e) {
            Activator.logError("Cannot parse file delivery policy XML", e);
        }
        this.checkForMissingElements(this.rootElements, newElementSet, false);
        this.checkForMissingElements(newElementSet, this.rootElements, true);
        this.fileTree.refresh(true);
    }

    private void checkForMissingElements(Set<PathElement> newElements, Set<PathElement> originalElements, boolean createMissing) {
        Iterator<PathElement> iter = newElements.iterator();
        while (iter.hasNext()) {
            PathElement newElement = iter.next();
            PathElement originalElement = null;
            for (PathElement e : originalElements) {
                if (!newElement.getName().equals(e.getName())) continue;
                originalElement = e;
                break;
            }
            if (originalElement == null) {
                if (createMissing) {
                    this.fileTree.refresh((Object)newElement, true);
                    originalElements.add(newElement);
                    continue;
                }
                iter.remove();
                continue;
            }
            if (newElement.isFile() != originalElement.isFile() && createMissing) {
                originalElements.add(newElement);
                continue;
            }
            if (newElement.isFile()) continue;
            this.checkForMissingElements(newElement.getChildrenSet(), originalElement.getChildrenSet(), createMissing);
        }
    }

    @Override
    public AgentPolicy updatePolicyFromControl() {
        FileDeliveryPolicy data = new FileDeliveryPolicy();
        data.elements = this.rootElements.toArray(new PathElement[this.rootElements.size()]);
        try {
            this.getPolicy().setContent(data.createXml());
        }
        catch (Exception e) {
            Activator.logError("Error serializing file delivery policy", e);
        }
        return this.getPolicy();
    }

    private void addDirectory() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        this.addElement((PathElement)selection.getFirstElement());
    }

    private void addFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4098);
        if (dlg.open() == null) {
            return;
        }
        final ArrayList<PathElement> uploadList = new ArrayList<PathElement>();
        String[] stringArray = dlg.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String name;
                block4: {
                    PathElement e;
                    block7: {
                        File f;
                        block5: {
                            name = stringArray[n2];
                            f = new File(dlg.getFilterPath(), name);
                            if (!f.exists()) break block4;
                            e = ((PathElement)selection.getFirstElement()).findChild(f.getName());
                            if (e == null) break block5;
                            if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"File overwrite confirmation", (String)("File with " + f.getName() + " already exist. Do you want to overwrite it?"))) break block6;
                            e.setFile(f);
                            break block7;
                        }
                        e = new PathElement((PathElement)selection.getFirstElement(), f.getName(), f, UUID.randomUUID(), new Date());
                        this.notSavedFiles.add(e.getGuid().toString());
                    }
                    uploadList.add(e);
                    break block6;
                }
                Activator.logInfo("File does not exist: " + name);
            }
            ++n2;
        }
        if (!uploadList.isEmpty()) {
            this.fileTree.refresh();
            this.fireModifyListeners();
            Activator.logInfo("FileDeliveryPolicyEditor: " + uploadList.size() + " files to upload");
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Upload files", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.datacollection", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    monitor.beginTask("Upload files", uploadList.size());
                    for (PathElement e : uploadList) {
                        Activator.logInfo("FileDeliveryPolicyEditor: uploading file " + e.getName() + " from " + e.getLocalFile());
                        monitor.subTask(e.getName());
                        session.uploadFileToServer(e.getLocalFile(), "FileDelivery-" + e.getGuid().toString(), null);
                        monitor.worked(1);
                    }
                    monitor.done();
                }

                protected String getErrorMessage() {
                    return "Cannot upload file";
                }
            }.start();
        }
    }

    private void deleteFile(final String name) {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Delete file", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.datacollection"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.deleteServerFile("FileDelivery-" + name);
            }

            protected String getErrorMessage() {
                return "Cannot delete file";
            }
        }.start();
    }

    private void updateFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || !((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        final UUID guid = ((PathElement)selection.getFirstElement()).getGuid();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Upload file", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.datacollection", null, (IStructuredSelection)selection){
            private final /* synthetic */ IStructuredSelection val$selection;
            {
                this.val$selection = iStructuredSelection;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
            }

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                session.uploadFileToServer(file, "FileDelivery-" + guid.toString(), new ProgressListener(){

                    public void setTotalWorkAmount(long workTotal) {
                        monitor.beginTask("Upload file", (int)file.length());
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)workDone);
                    }
                });
                monitor.done();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((PathElement)val$selection.getFirstElement()).updateCreationTime();
                        FileDeliveryPolicyEditor.this.fileTree.refresh(true);
                        FileDeliveryPolicyEditor.this.fireModifyListeners();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot upload file";
            }
        }.start();
    }

    private void addElement(final PathElement parent) {
        InputDialog dlg = new InputDialog(this.getShell(), parent == null ? "New root directory" : "New directory", "Enter name for new directory", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.isEmpty()) {
                    return "Name cannot be empty";
                }
                if (parent != null) {
                    PathElement[] pathElementArray = parent.getChildren();
                    int n = pathElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PathElement el = pathElementArray[n2];
                        if (newText.equalsIgnoreCase(el.getName())) {
                            return "Object with this name already exists";
                        }
                        ++n2;
                    }
                }
                return null;
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        PathElement e = new PathElement(parent, dlg.getValue());
        if (parent == null) {
            this.rootElements.add(e);
            this.fileTree.refresh(true);
        } else {
            this.fileTree.refresh();
        }
        this.fireModifyListeners();
    }

    private void renameElement() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final PathElement element = (PathElement)selection.getFirstElement();
        InputDialog dlg = new InputDialog(this.getShell(), element.isFile() ? "Rename file" : "Rename directory", "Enter new name", element.getName(), new IInputValidator(){

            public String isValid(String newText) {
                if (newText.isEmpty()) {
                    return "Name cannot be empty";
                }
                if (element.getParent() != null) {
                    PathElement[] pathElementArray = element.getParent().getChildren();
                    int n = pathElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PathElement el = pathElementArray[n2];
                        if (!el.equals(element) && newText.equalsIgnoreCase(el.getName())) {
                            return "Object with this name already exists";
                        }
                        ++n2;
                    }
                }
                return null;
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        ((PathElement)selection.getFirstElement()).updateCreationTime();
        if (element.getParent() == null) {
            this.rootElements.remove(element);
            element.setName(dlg.getValue());
            this.rootElements.add(element);
            this.fileTree.refresh();
        } else {
            element.setName(dlg.getValue());
            this.fileTree.update((Object)element, null);
        }
        this.fireModifyListeners();
    }

    private void deleteElements() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Delete confirmation", (String)"Delete selected files?")) {
            return;
        }
        for (Object o : selection.toList()) {
            PathElement element = (PathElement)o;
            if (element.isFile()) {
                this.deleteFiles(element);
            }
            if (element.getParent() == null) {
                this.rootElements.remove(o);
                continue;
            }
            element.remove();
        }
        this.fileTree.refresh(true);
        this.fireModifyListeners();
    }

    private void deleteFiles(PathElement element) {
        if (element.isFile()) {
            this.filesForDeletion.add(element.getGuid().toString());
        } else {
            PathElement[] pathElementArray = element.getChildren();
            int n = pathElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathElement el = pathElementArray[n2];
                this.deleteFiles(el);
                ++n2;
            }
        }
    }

    @Override
    public void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    @Override
    public void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    public boolean canPerformFind() {
        return false;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return 0;
    }

    public Point getSelection() {
        return null;
    }

    public String getSelectionText() {
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }

    @Override
    public boolean isFindAndReplaceRequired() {
        return false;
    }

    @Override
    public void onSave() {
        this.notSavedFiles.clear();
        for (String name : this.filesForDeletion) {
            this.deleteFile(name);
        }
        this.filesForDeletion.clear();
    }

    @Override
    public void onDiscard() {
        for (String name : this.notSavedFiles) {
            this.deleteFile(name);
        }
        this.notSavedFiles.clear();
    }
}

