/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.LogMacroEditDialog;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParser;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFile;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFileEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserModifyListener;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRuleEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.MacroListLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.TextEditor;

public class LogParserEditor
extends Composite
implements IFindReplaceTarget {
    public static final int TYPE_POLICY = 0;
    public static final int TYPE_SYSLOG = 1;
    public static final int TYPE_WIN_EVENT = 2;
    private static final int TAB_NONE = 0;
    private static final int TAB_BUILDER = 1;
    private static final int TAB_XML = 2;
    private CTabFolder tabFolder;
    private int currentTab = 0;
    private TextEditor xmlEditor;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Set<LogParserModifyListener> listeners = new HashSet<LogParserModifyListener>();
    private boolean enableModifyListeners = true;
    private LogParser parser = new LogParser();
    private Composite rulesArea;
    private Composite fileArea;
    private ImageHyperlink addColumnLink;
    private ImageHyperlink addFileLink;
    private SortableTableViewer macroList;
    private int type;
    private FindReplaceAction actionFindReplace = null;
    private LabeledText labelName;
    private Spinner spinnerTrace;
    private Button checkProcessAll;

    public LogParserEditor(Composite parent, int style, int type) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.type = type;
        this.tabFolder = new CTabFolder((Composite)this, 8389634);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setSimple(true);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String xml;
                switch (LogParserEditor.this.currentTab) {
                    case 1: {
                        xml = LogParserEditor.this.parser != null ? LogParserEditor.this.buildParserXml() : "";
                        break;
                    }
                    case 2: {
                        xml = LogParserEditor.this.xmlEditor.getText();
                        break;
                    }
                    default: {
                        xml = null;
                    }
                }
                CTabItem tab = LogParserEditor.this.tabFolder.getSelection();
                LogParserEditor.this.currentTab = tab != null ? (Integer)tab.getData() : 0;
                if (xml != null) {
                    switch (LogParserEditor.this.currentTab) {
                        case 1: {
                            LogParserEditor.this.updateBuilderFromXml(LogParserEditor.this.xmlEditor.getText());
                            break;
                        }
                        case 2: {
                            if (LogParserEditor.this.parser == null) break;
                            LogParserEditor.this.xmlEditor.setText(LogParserEditor.this.buildParserXml());
                            break;
                        }
                    }
                }
                if (LogParserEditor.this.actionFindReplace != null) {
                    LogParserEditor.this.actionFindReplace.setEnabled(LogParserEditor.this.currentTab == 2);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createForm();
        this.createTextEditor();
    }

    private void selectXmlEditor() {
        CTabItem tab = this.tabFolder.getSelection();
        if (tab != null && (Integer)tab.getData() == 2) {
            return;
        }
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem t = cTabItemArray[n2];
            if ((Integer)t.getData() == 2) {
                this.tabFolder.setSelection(t);
                this.currentTab = 2;
                break;
            }
            ++n2;
        }
    }

    private void createForm() {
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createScrolledForm((Composite)this.tabFolder);
        Messages.get();
        this.form.setText(Messages.LogParserEditor_LogParser);
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_Editor);
        tabItem.setImage(SharedIcons.IMG_EDIT);
        tabItem.setControl((Control)this.form);
        tabItem.setData((Object)1);
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("General");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite generalArea = this.toolkit.createComposite((Composite)section);
        this.createGeneralArea(generalArea);
        section.setClient((Control)generalArea);
        section = this.toolkit.createSection(this.form.getBody(), 290);
        Messages.get();
        section.setText(Messages.LogParserEditor_Macros);
        td = new TableWrapData();
        td.align = 128;
        section.setLayoutData((Object)td);
        Composite macroArea = this.toolkit.createComposite((Composite)section);
        this.createMacroSection(macroArea);
        section.setClient((Control)macroArea);
        section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.LogParserEditor_Rules);
        td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        this.rulesArea = this.toolkit.createComposite((Composite)section);
        GridLayout rulesAreaLayout = new GridLayout();
        rulesAreaLayout.marginHeight = 0;
        rulesAreaLayout.marginWidth = 0;
        rulesAreaLayout.verticalSpacing = 1;
        this.rulesArea.setLayout((Layout)rulesAreaLayout);
        section.setClient((Control)this.rulesArea);
        this.addColumnLink = this.toolkit.createImageHyperlink(this.rulesArea, 0);
        Messages.get();
        this.addColumnLink.setText(Messages.LogParserEditor_AddRule);
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addRule();
            }
        });
        this.form.reflow(true);
    }

    private void createGeneralArea(Composite generalArea) {
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        generalArea.setLayout((Layout)layout);
        WidgetFactory spinnerFactory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new Spinner(parent, style);
            }
        };
        this.labelName = new LabeledText(generalArea, 0);
        this.labelName.setLabel("Parser name");
        this.labelName.setText(this.parser.getName() != null ? this.parser.getName() : "");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.labelName.setLayoutData((Object)gd);
        this.labelName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.spinnerTrace = (Spinner)WidgetHelper.createLabeledControl((Composite)generalArea, (int)2048, (WidgetFactory)spinnerFactory, (String)"Trace level", (Object)gd);
        this.spinnerTrace.setMinimum(0);
        this.spinnerTrace.setMaximum(9);
        this.spinnerTrace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        this.spinnerTrace.setSelection(this.parser.getTrace() != null ? this.parser.getTrace() : 0);
        this.checkProcessAll = this.toolkit.createButton(generalArea, "Process all", 32);
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        this.checkProcessAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        if (this.type == 0) {
            this.fileArea = new Composite(generalArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fileArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalSpan = 3;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.fileArea.setLayoutData((Object)gd);
            this.addFileLink = this.toolkit.createImageHyperlink(this.fileArea, 0);
            this.addFileLink.setText("Add file");
            this.addFileLink.setImage(SharedIcons.IMG_ADD_OBJECT);
            this.addFileLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    LogParserEditor.this.addFile();
                }
            });
        }
    }

    private void createTextEditor() {
        this.xmlEditor = new TextEditor((Composite)this.tabFolder, 0, 770);
        this.xmlEditor.getTextControl().setFont(JFaceResources.getTextFont());
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_XML);
        tabItem.setImage(SharedIcons.IMG_XML);
        tabItem.setControl((Control)this.xmlEditor);
        tabItem.setData((Object)2);
        this.xmlEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
    }

    private void createMacroSection(Composite macroArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        macroArea.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.LogParserEditor_Name;
        Messages.get();
        stringArray[1] = Messages.LogParserEditor_Value;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{100, 200};
        this.macroList = new SortableTableViewer(macroArea, columnNames, columnWidths, 0, 128, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        Table table = this.macroList.getTable();
        table.setLayoutData((Object)gd);
        this.macroList.setLabelProvider((IBaseLabelProvider)new MacroListLabelProvider());
        this.macroList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.macroList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result;
                Map.Entry d1 = (Map.Entry)e1;
                Map.Entry d2 = (Map.Entry)e2;
                switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
                    case 0: {
                        result = ((String)d1.getKey()).compareTo((String)d2.getKey());
                        break;
                    }
                    case 1: {
                        result = ((String)d1.getValue()).compareTo((String)d2.getValue());
                        break;
                    }
                    default: {
                        result = 0;
                    }
                }
                return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
            }
        });
        ImageHyperlink link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Add);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addMacro();
            }
        });
        link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_EDIT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Edit);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.editMacro();
            }
        });
        link = this.toolkit.createImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Delete);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.deleteMacro();
            }
        });
    }

    public void addModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    public void fireModifyListeners() {
        if (this.enableModifyListeners) {
            for (LogParserModifyListener l : this.listeners) {
                l.modifyParser();
            }
        }
    }

    public String getParserXml() {
        switch (this.currentTab) {
            case 1: {
                return this.buildParserXml();
            }
            case 2: {
                return this.xmlEditor.getText();
            }
        }
        return "<parser></parser>";
    }

    private String buildParserXml() {
        if (this.type == 1) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().save();
            }
        }
        this.parser.setName(this.labelName.getText());
        this.parser.setProcessALL(this.checkProcessAll.getSelection());
        this.parser.setTrace(this.spinnerTrace.getSelection());
        for (LogParserRule rule : this.parser.getRules()) {
            rule.getEditor().save();
        }
        try {
            return this.parser.createXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<parser>\n</parser>";
        }
    }

    public void setParserXml(String xml) {
        this.enableModifyListeners = false;
        this.xmlEditor.setText(xml);
        this.updateBuilderFromXml(xml);
        this.enableModifyListeners = true;
    }

    private void updateBuilderFromXml(String xml) {
        if (this.parser != null) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().dispose();
            }
            for (LogParserRule rule : this.parser.getRules()) {
                rule.getEditor().dispose();
            }
        }
        try {
            this.parser = LogParser.createFromXml(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.LogParserEditor_Error, (String)Messages.LogParserEditor_InvalidDefinition);
            this.parser = null;
            this.selectXmlEditor();
            return;
        }
        this.parser.setSyslogParser(this.type);
        if (this.type == 0) {
            for (LogParserFile file : this.parser.getFiles()) {
                this.createFileEditor(file).moveAbove((Control)this.addFileLink);
            }
        }
        this.labelName.setText(this.parser.getName());
        this.spinnerTrace.setSelection(this.parser.getTrace() != null ? this.parser.getTrace() : 0);
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        for (LogParserRule rule : this.parser.getRules()) {
            this.createRuleEditor(rule).moveAbove((Control)this.addColumnLink);
        }
        this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
        this.form.reflow(true);
        this.form.getParent().layout(true, true);
    }

    private LogParserRuleEditor createRuleEditor(LogParserRule rule) {
        LogParserRuleEditor editor = new LogParserRuleEditor(this.rulesArea, this.toolkit, rule, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        rule.setEditor(editor);
        return editor;
    }

    private void addRule() {
        LogParserRule rule = new LogParserRule();
        LogParserRuleEditor editor = this.createRuleEditor(rule);
        editor.moveAbove((Control)this.addColumnLink);
        this.parser.getRules().add(rule);
        this.form.reflow(true);
        this.fireModifyListeners();
    }

    private LogParserFileEditor createFileEditor(LogParserFile file) {
        LogParserFileEditor editor = new LogParserFileEditor(this.fileArea, this.toolkit, file, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        file.setEditor(editor);
        return editor;
    }

    private void addFile() {
        LogParserFile file = new LogParserFile();
        LogParserFileEditor editor = this.createFileEditor(file);
        editor.moveAbove((Control)this.addFileLink);
        this.parser.getFiles().add(file);
        this.form.reflow(true);
        this.fireModifyListeners();
    }

    private void addMacro() {
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void editMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void deleteMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Map<String, String> macros = this.parser.getMacros();
        for (Object o : selection.toList()) {
            macros.remove(((Map.Entry)o).getKey());
        }
        this.macroList.setInput((Object)macros.entrySet().toArray());
        this.fireModifyListeners();
    }

    public void deleteRule(LogParserRule rule) {
        this.parser.getRules().remove(rule);
        rule.getEditor().dispose();
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void deleteFile(LogParserFile file) {
        this.parser.getFiles().remove(file);
        file.getEditor().dispose();
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleUp(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 1) {
            return;
        }
        rule.getEditor().moveAbove((Control)this.parser.getRules().get(index - 1).getEditor());
        Collections.swap(this.parser.getRules(), index - 1, index);
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleDown(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 0 || index >= this.parser.getRules().size() - 1) {
            return;
        }
        rule.getEditor().moveBelow((Control)this.parser.getRules().get(index + 1).getEditor());
        Collections.swap(this.parser.getRules(), index + 1, index);
        this.form.reflow(true);
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public int getParserType() {
        return this.type;
    }

    public boolean isWindowsEventLogParser() {
        boolean isWindowsEventLogParser = false;
        for (LogParserFile file : this.parser.getFiles()) {
            if (!file.getEditor().getFile().startsWith("*")) continue;
            isWindowsEventLogParser = true;
            break;
        }
        return isWindowsEventLogParser;
    }

    public void updateRules() {
        for (LogParserRule rule : this.parser.getRules()) {
            if (rule.getEditor() == null) continue;
            rule.getEditor().updateWindowsEventLogFields();
        }
    }

    public void setFindAndReplaceAction(FindReplaceAction actionFindReplace) {
        this.actionFindReplace = actionFindReplace;
    }

    public boolean isEditorTabSelected() {
        return this.currentTab == 2;
    }

    public boolean canPerformFind() {
        return this.isEditorTabSelected();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        if (!this.isEditorTabSelected()) {
            return -1;
        }
        return this.xmlEditor.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.xmlEditor.getSelection();
    }

    public String getSelectionText() {
        return this.xmlEditor.getSelectionText();
    }

    public boolean isEditable() {
        return this.isEditorTabSelected();
    }

    public void replaceSelection(String text) {
        if (!this.isEditorTabSelected()) {
            return;
        }
        this.xmlEditor.replaceSelection(text);
    }
}

