/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerVariable;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DiscoveryConfig {
    public static final int DISCOVERY_TYPE_NONE = 0;
    public static final int DISCOVERY_TYPE_PASSIVE = 1;
    public static final int DISCOVERY_TYPE_ACTIVE = 2;
    public static final int DISCOVERY_TYPE_ACTIVE_PASSIVE = 3;
    public static final int DEFAULT_ACTIVE_INTERVAL = 7200;
    private int discoveryType;
    private boolean useSnmpTraps;
    private boolean useSyslog;
    private int filterFlags;
    private String filter;
    private int passiveDiscoveryPollInterval;
    private int activeDiscoveryPollInterval;
    private String activeDiscoveryPollSchedule;
    private List<InetAddressListElement> targets;
    private List<InetAddressListElement> addressFilter;

    private DiscoveryConfig() {
    }

    public static DiscoveryConfig load() throws NXCException, IOException {
        DiscoveryConfig config = new DiscoveryConfig();
        NXCSession session = ConsoleSharedData.getSession();
        Map variables = session.getServerVariables();
        config.discoveryType = DiscoveryConfig.getInteger(variables, "NetworkDiscovery.Type", 0);
        config.useSnmpTraps = DiscoveryConfig.getBoolean(variables, "UseSNMPTrapsForDiscovery", false);
        config.useSyslog = DiscoveryConfig.getBoolean(variables, "UseSyslogForDiscovery", false);
        config.filterFlags = DiscoveryConfig.getInteger(variables, "DiscoveryFilterFlags", 0);
        config.filter = DiscoveryConfig.getString(variables, "DiscoveryFilter", "none");
        config.passiveDiscoveryPollInterval = DiscoveryConfig.getInteger(variables, "NetworkDiscovery.PassiveDiscovery.Interval", 900);
        config.activeDiscoveryPollInterval = DiscoveryConfig.getInteger(variables, "NetworkDiscovery.ActiveDiscovery.Interval", 7200);
        config.activeDiscoveryPollSchedule = DiscoveryConfig.getString(variables, "NetworkDiscovery.ActiveDiscovery.Schedule", "");
        config.addressFilter = session.getAddressList(2);
        config.targets = session.getAddressList(1);
        return config;
    }

    private static boolean getBoolean(Map<String, ServerVariable> variables, String name, boolean defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue()) != 0;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    private static int getInteger(Map<String, ServerVariable> variables, String name, int defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue());
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    private static String getString(Map<String, ServerVariable> variables, String name, String defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        return v.getValue();
    }

    public void save() throws NXCException, IOException {
        NXCSession session = ConsoleSharedData.getSession();
        session.setServerVariable("NetworkDiscovery.Type", Integer.toString(this.discoveryType));
        session.setServerVariable("UseSNMPTrapsForDiscovery", this.useSnmpTraps ? "1" : "0");
        session.setServerVariable("UseSyslogForDiscovery", this.useSyslog ? "1" : "0");
        session.setServerVariable("DiscoveryFilterFlags", Integer.toString(this.filterFlags));
        session.setServerVariable("DiscoveryFilter", this.filter);
        session.setServerVariable("NetworkDiscovery.PassiveDiscovery.Interval", Integer.toString(this.passiveDiscoveryPollInterval));
        session.setServerVariable("NetworkDiscovery.ActiveDiscovery.Interval", Integer.toString(this.activeDiscoveryPollInterval));
        session.setServerVariable("NetworkDiscovery.ActiveDiscovery.Schedule", this.activeDiscoveryPollSchedule);
        session.setAddressList(2, this.addressFilter);
        session.setAddressList(1, this.targets);
        session.resetServerComponent(1);
    }

    public int getFilterFlags() {
        return this.filterFlags;
    }

    public void setFilterFlags(int filterFlags) {
        this.filterFlags = filterFlags;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<InetAddressListElement> getTargets() {
        return this.targets;
    }

    public void setTargets(List<InetAddressListElement> targets) {
        this.targets = targets;
    }

    public List<InetAddressListElement> getAddressFilter() {
        return this.addressFilter;
    }

    public void setAddressFilter(List<InetAddressListElement> addressFilter) {
        this.addressFilter = addressFilter;
    }

    public boolean isUseSnmpTraps() {
        return this.useSnmpTraps;
    }

    public void setUseSnmpTraps(boolean useSnmpTraps) {
        this.useSnmpTraps = useSnmpTraps;
    }

    public boolean isUseSyslog() {
        return this.useSyslog;
    }

    public void setUseSyslog(boolean useSyslog) {
        this.useSyslog = useSyslog;
    }

    public int getDiscoveryType() {
        return this.discoveryType;
    }

    public void setDiscoveryType(int discoveryType) {
        this.discoveryType = discoveryType;
    }

    public int getActiveDiscoveryPollInterval() {
        return this.activeDiscoveryPollInterval;
    }

    public void setActiveDiscoveryPollInterval(int activeDiscoveryPollInterval) {
        this.activeDiscoveryPollInterval = activeDiscoveryPollInterval;
    }

    public String getActiveDiscoveryPollSchedule() {
        return this.activeDiscoveryPollSchedule;
    }

    public void setActiveDiscoveryPollSchedule(String activeDiscoveryPollSchedule) {
        this.activeDiscoveryPollSchedule = activeDiscoveryPollSchedule;
    }

    public int getPassiveDiscoveryPollInterval() {
        return this.passiveDiscoveryPollInterval;
    }

    public void setPassiveDiscoveryPollInterval(int passiveDiscoveryPollInterval) {
        this.passiveDiscoveryPollInterval = passiveDiscoveryPollInterval;
    }
}

