/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.List;
import java.util.UUID;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.dialogs.EditGroupBoxDialog;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class PredefinedMap
extends AbstractNetworkMapView
implements ImageUpdateListener {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.PredefinedMap";
    private NetworkMap mapObject;
    private Action actionAddObject;
    private Action actionAddDCIContainer;
    private Action actionLinkObjects;
    private Action actionAddGroupBox;
    private Action actionAddImage;
    private Action actionRemove;
    private Action actionDCIContainerProperties;
    private Action actionDCIImageProperties;
    private Action actionMapProperties;
    private Action actionLinkProperties;
    private Action actionAddDCIImage;
    private Action actionAddTextBox;
    private Action actionTextBoxProperties;
    private Action actionGroupBoxProperties;
    private Action actionImageProperties;
    private Color defaultLinkColor = null;
    private boolean readOnly;

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.mapObject = (NetworkMap)this.rootObject;
        this.setPartName(this.rootObject.getObjectName());
        ConsoleJob job = new ConsoleJob("Get map effective rights", (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PredefinedMap.this.readOnly = (PredefinedMap.this.mapObject.getEffectiveRights() & 2) == 0;
            }

            protected String getErrorMessage() {
                return "Cannot get effective rights for map";
            }
        };
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = this.allowManualLayout = !this.readOnly;
        if (this.mapObject.getLayout() == MapLayoutAlgorithm.MANUAL) {
            this.automaticLayoutEnabled = false;
        } else {
            this.automaticLayoutEnabled = true;
            this.layoutAlgorithm = this.mapObject.getLayout();
        }
        this.syncObjects();
    }

    @Override
    public void setupMapControl() {
        if (this.readOnly) {
            this.viewer.setDraggingEnabled(false);
        } else {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PredefinedMap.this.actionLinkObjects.setEnabled(((IStructuredSelection)event.getSelection()).size() == 2);
                }
            });
            this.addDropSupport();
        }
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        if (this.mapObject.getBackground() != null && this.mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (this.mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        this.setConnectionRouter(this.mapObject.getDefaultLinkRouting(), false);
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)this.mapObject.getBackgroundColor()));
        if (this.mapObject.getDefaultLinkColor() >= 0) {
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.setObjectDisplayMode(this.mapObject.getObjectDisplayMode(), false);
        this.labelProvider.setShowStatusBackground((this.mapObject.getFlags() & 4) > 0);
        this.labelProvider.setShowStatusFrame((this.mapObject.getFlags() & 2) > 0);
        this.labelProvider.setShowStatusIcons((this.mapObject.getFlags() & 1) > 0);
        this.labelProvider.setShowLinkDirection((this.mapObject.getFlags() & 0x40) > 0);
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
    }

    private void addDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private int x;
            private int y;

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                for (Object object : selection) {
                    if (object instanceof AbstractObject && ((AbstractObject)object).isAllowedOnMap()) continue;
                    return false;
                }
                return true;
            }

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                PredefinedMap.this.addObjectsFromList(selection.toList(), PredefinedMap.this.viewer.getControl().toControl(this.x, this.y));
                return true;
            }

            public void dropAccept(DropTargetEvent event) {
                this.x = event.x;
                this.y = event.y;
                super.dropAccept(event);
            }
        });
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = this.mapObject.createMapPage();
        this.addDciToRequestList();
    }

    private void syncObjects() {
        this.mapPage = this.mapObject.createMapPage();
        final List mapObjectIds = this.mapPage.getObjectIds();
        mapObjectIds.addAll(this.mapPage.getAllLinkStatusObjects());
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.PredefinedMap_SaveJobTitle, this.rootObject.getObjectName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PredefinedMap.this.session.syncMissingObjects(mapObjectIds, true, 2);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).PredefinedMap.this.viewer.getControl().isDisposed()) {
                            PredefinedMap.this.refreshMap();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PredefinedMap_SaveJobError;
            }
        };
        job.setUser(false);
        job.start();
    }

    @Override
    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionAddObject = new Action(Messages.PredefinedMap_AddObject){

            public void run() {
                PredefinedMap.this.addObjectToMap();
            }
        };
        this.actionAddObject.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.AddObject");
        this.actionAddObject.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.AddObject");
        handlerService.activateHandler(this.actionAddObject.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionAddObject));
        Messages.get();
        this.actionAddDCIContainer = new Action(Messages.PredefinedMap_AddDciContainer){

            public void run() {
                PredefinedMap.this.addDCIContainerToMap();
            }
        };
        this.actionAddDCIContainer.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.AddDCIContainer");
        this.actionAddDCIContainer.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.AddDCIContainer");
        handlerService.activateHandler(this.actionAddDCIContainer.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionAddDCIContainer));
        Messages.get();
        this.actionAddDCIImage = new Action(Messages.PredefinedMap_AddDciImage){

            public void run() {
                PredefinedMap.this.addDCIImageToMap();
            }
        };
        this.actionAddDCIImage.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.AddDCIImage");
        this.actionAddDCIImage.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.AddDCIImage");
        handlerService.activateHandler(this.actionAddDCIImage.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionAddDCIImage));
        Messages.get();
        this.actionAddGroupBox = new Action(Messages.PredefinedMap_GroupBox){

            public void run() {
                PredefinedMap.this.addGroupBoxDecoration();
            }
        };
        Messages.get();
        this.actionGroupBoxProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.editGroupBox();
            }
        };
        Messages.get();
        this.actionAddImage = new Action(Messages.PredefinedMap_Image){

            public void run() {
                PredefinedMap.this.addImageDecoration();
            }
        };
        Messages.get();
        this.actionImageProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.editImageDecoration();
            }
        };
        Messages.get();
        this.actionLinkObjects = new Action(Messages.PredefinedMap_LinkObjects, Activator.getImageDescriptor("icons/link_add.png")){

            public void run() {
                PredefinedMap.this.linkSelectedObjects();
            }
        };
        this.actionLinkObjects.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.LinkObjects");
        this.actionLinkObjects.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.LinkObjects");
        handlerService.activateHandler(this.actionLinkObjects.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionLinkObjects));
        Messages.get();
        this.actionRemove = new Action(Messages.PredefinedMap_RemoveFromMap, SharedIcons.DELETE_OBJECT){

            public void run() {
                PredefinedMap.this.removeSelectedElements();
            }
        };
        this.actionRemove.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.Remove");
        this.actionRemove.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.Remove");
        handlerService.activateHandler(this.actionRemove.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRemove));
        Messages.get();
        this.actionDCIContainerProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.showDCIContainerProperties();
            }
        };
        Messages.get();
        this.actionDCIImageProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.showDCIImageProperties();
            }
        };
        Messages.get();
        this.actionMapProperties = new Action(Messages.PredefinedMap_MapProperties){

            public void run() {
                PredefinedMap.this.showMapProperties();
            }
        };
        Messages.get();
        this.actionLinkProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.showLinkProperties();
            }
        };
        this.actionAddTextBox = new Action("Text box"){

            public void run() {
                PredefinedMap.this.addTextBoxToMap();
            }
        };
        Messages.get();
        this.actionTextBoxProperties = new Action(Messages.PredefinedMap_Properties){

            public void run() {
                PredefinedMap.this.showTextBoxProperties();
            }
        };
    }

    private IMenuManager createDecorationAdditionSubmenu() {
        Messages.get();
        MenuManager menu = new MenuManager(Messages.PredefinedMap_AddDecoration);
        menu.add((IAction)this.actionAddGroupBox);
        menu.add((IAction)this.actionAddImage);
        menu.add((IAction)this.actionAddTextBox);
        return menu;
    }

    @Override
    protected void fillMapContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionAddDCIContainer);
            manager.add((IAction)this.actionAddDCIImage);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillMapContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    @Override
    protected void fillObjectContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            int size = ((IStructuredSelection)this.viewer.getSelection()).size();
            if (size == 2) {
                manager.add((IAction)this.actionLinkObjects);
            }
            manager.add((IAction)this.actionRemove);
            manager.add((IContributionItem)new Separator());
        }
        super.fillObjectContextMenu(manager);
    }

    @Override
    protected void fillLinkContextMenu(IMenuManager manager) {
        if (this.readOnly) {
            super.fillLinkContextMenu(manager);
            return;
        }
        int size = ((IStructuredSelection)this.viewer.getSelection()).size();
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLockLink);
        manager.add((IContributionItem)new Separator());
        super.fillLinkContextMenu(manager);
        if (size == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionLinkProperties);
        }
    }

    @Override
    protected void fillElementContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionRemove);
            Object o = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (o instanceof NetworkMapDCIContainer) {
                manager.add((IAction)this.actionDCIContainerProperties);
            } else if (o instanceof NetworkMapDCIImage) {
                manager.add((IAction)this.actionDCIImageProperties);
            } else if (o instanceof NetworkMapTextBox) {
                manager.add((IAction)this.actionTextBoxProperties);
            } else if (o instanceof NetworkMapDecoration) {
                manager.add((IAction)(((NetworkMapDecoration)o).getDecorationType() == 1 ? this.actionImageProperties : this.actionGroupBoxProperties));
            }
            manager.add((IContributionItem)new Separator());
        }
        super.fillElementContextMenu(manager);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void saveLayout() {
        this.saveMap();
    }

    private void addObjectToMap() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        this.addObjectsFromList(dlg.getSelectedObjects(), null);
    }

    private void addDCIContainerToMap() {
        NetworkMapDCIContainer dciContainer = new NetworkMapDCIContainer(this.mapPage.createElementId());
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)dciContainer);
        if (dlg != null && dlg.open() == 0) {
            this.mapPage.addElement((NetworkMapElement)dciContainer);
            this.saveMap();
            this.addDciToRequestList();
        }
    }

    private void addDCIImageToMap() {
        NetworkMapDCIImage dciImage = new NetworkMapDCIImage(this.mapPage.createElementId());
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)dciImage);
        if (dlg != null && dlg.open() == 0) {
            this.mapPage.addElement((NetworkMapElement)dciImage);
            this.saveMap();
            this.addDciToRequestList();
        }
    }

    private void addObjectsFromList(List<AbstractObject> list, Point location) {
        int added = 0;
        for (AbstractObject object : list) {
            if (this.mapPage.findObjectElement(object.getObjectId()) != null) continue;
            NetworkMapObject mapObject = new NetworkMapObject(this.mapPage.createElementId(), object.getObjectId());
            if (location != null) {
                mapObject.setLocation(location.x, location.y);
            } else {
                mapObject.setLocation(40, 40);
            }
            this.mapPage.addElement((NetworkMapElement)mapObject);
            ++added;
        }
        if (added > 0) {
            this.saveMap();
        }
    }

    private void linkSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        long id1 = ((NetworkMapObject)objects[0]).getId();
        long id2 = ((NetworkMapObject)objects[1]).getId();
        this.mapPage.addLink(new NetworkMapLink(0, id1, id2));
        this.saveMap();
    }

    private void removeSelectedElements() {
        Object[] objects;
        String string;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Shell shell = this.getSite().getShell();
        Messages.get();
        if (selection.size() == 1) {
            Messages.get();
            string = Messages.PredefinedMap_RemovalConfirmationSingular;
        } else {
            Messages.get();
            string = Messages.PredefinedMap_RemovalConfirmationPlural;
        }
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.PredefinedMap_ConfirmRemoval, (String)string)) {
            return;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof AbstractObject) {
                this.mapPage.removeObjectElement(((AbstractObject)element).getObjectId());
            } else if (element instanceof NetworkMapElement) {
                this.mapPage.removeElement(((NetworkMapElement)element).getId());
            } else if (element instanceof NetworkMapLink) {
                this.mapPage.removeLink((NetworkMapLink)element);
            }
            ++n2;
        }
        this.saveMap();
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void addGroupBoxDecoration() {
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 0);
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getSite().getShell(), element);
        if (dlg.open() != 0) {
            return;
        }
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void addImageDecoration() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 1);
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void addTextBoxToMap() {
        NetworkMapTextBox textBox = new NetworkMapTextBox(this.mapPage.createElementId());
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)textBox);
        if (dlg.open() != 0) {
            return;
        }
        this.mapPage.addElement((NetworkMapElement)textBox);
        this.saveMap();
    }

    private void saveMap() {
        this.updateObjectPositions();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.rootObject.getObjectId());
        md.setMapContent(this.mapPage.getElements(), this.mapPage.getLinks());
        md.setMapLayout(this.automaticLayoutEnabled ? this.layoutAlgorithm : MapLayoutAlgorithm.MANUAL);
        md.setConnectionRouting(this.routingAlgorithm);
        md.setMapObjectDisplayMode(this.labelProvider.getObjectFigureType());
        int flags = this.mapObject.getFlags();
        flags = this.labelProvider.isShowStatusIcons() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        flags = this.labelProvider.isShowStatusFrame() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = this.labelProvider.isShowStatusBackground() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        flags = this.labelProvider.isShowLinkDirection() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        md.setObjectFlags(flags);
        Messages.get();
        new ConsoleJob(String.format(Messages.PredefinedMap_SaveJobTitle, this.rootObject.getObjectName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PredefinedMap.this.session.modifyObject(md);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PredefinedMap.this.viewer.setInput((this).PredefinedMap.this.mapPage);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PredefinedMap_SaveJobError;
            }
        }.start();
        this.addDciToRequestList();
    }

    private void showMapProperties() {
        this.updateObjectPositions();
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)this.mapObject);
        dlg.open();
    }

    @Override
    protected boolean isSelectableElement(Object element) {
        return element instanceof NetworkMapDecoration || element instanceof NetworkMapLink || element instanceof NetworkMapDCIContainer || element instanceof NetworkMapDCIImage || element instanceof NetworkMapTextBox;
    }

    public void imageUpdated(final UUID guid) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (guid.equals(PredefinedMap.this.mapObject.getBackground())) {
                    PredefinedMap.this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(guid));
                }
                String guidText = guid.toString();
                for (NetworkMapElement e : PredefinedMap.this.mapPage.getElements()) {
                    if (!(e instanceof NetworkMapDecoration) || ((NetworkMapDecoration)e).getDecorationType() != 1 || !((NetworkMapDecoration)e).getTitle().equals(guidText)) continue;
                    PredefinedMap.this.viewer.updateDecorationFigure((NetworkMapElement)((NetworkMapDecoration)e));
                    break;
                }
            }
        });
    }

    @Override
    public void dispose() {
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        super.dispose();
    }

    @Override
    protected void onObjectChange(AbstractObject object) {
        super.onObjectChange(object);
        if (object.getObjectId() != this.mapObject.getObjectId()) {
            return;
        }
        UUID oldBackground = this.mapObject.getBackground();
        this.mapObject = (NetworkMap)object;
        if (!oldBackground.equals(this.mapObject.getBackground()) || this.mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
            if (this.mapObject.getBackground().equals(NXCommon.EMPTY_GUID)) {
                this.viewer.setBackgroundImage(null);
            } else if (this.mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)this.mapObject.getBackgroundColor()));
        this.setConnectionRouter(this.mapObject.getDefaultLinkRouting(), false);
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        this.defaultLinkColor = this.mapObject.getDefaultLinkColor() >= 0 ? new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getDefaultLinkColor())) : null;
        this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        if (this.mapObject.getBackground() != null && this.mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (this.mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        this.setLayoutAlgorithm(this.mapObject.getLayout(), false);
        this.setObjectDisplayMode(this.mapObject.getObjectDisplayMode(), false);
        this.labelProvider.setShowStatusBackground((this.mapObject.getFlags() & 4) > 0);
        this.labelProvider.setShowStatusFrame((this.mapObject.getFlags() & 2) > 0);
        this.labelProvider.setShowStatusIcons((this.mapObject.getFlags() & 1) > 0);
        this.labelProvider.setShowLinkDirection((this.mapObject.getFlags() & 0x40) > 0);
        this.syncObjects();
    }

    private void showDCIContainerProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIContainer)) {
            return;
        }
        NetworkMapDCIContainer container = (NetworkMapDCIContainer)selection.getFirstElement();
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)container);
        if (dlg != null && dlg.open() == 0) {
            this.saveMap();
        }
    }

    private void showDCIImageProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIImage)) {
            return;
        }
        NetworkMapDCIImage container = (NetworkMapDCIImage)selection.getFirstElement();
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)container);
        if (dlg != null && dlg.open() == 0) {
            this.saveMap();
        }
    }

    private void showLinkProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapLink)) {
            return;
        }
        LinkEditor link = new LinkEditor((NetworkMapLink)selection.getFirstElement(), this.mapPage);
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)link);
        if (dlg != null) {
            dlg.open();
            if (link.isModified()) {
                this.saveMap();
            }
        }
    }

    private void showTextBoxProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapTextBox)) {
            return;
        }
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)((NetworkMapTextBox)selection.getFirstElement()));
        if (dlg.open() != 0) {
            return;
        }
        this.saveMap();
    }

    private void editImageDecoration() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = (NetworkMapDecoration)selection.getFirstElement();
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void editGroupBox() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        NetworkMapDecoration groupBox = (NetworkMapDecoration)selection.getFirstElement();
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getSite().getShell(), groupBox);
        if (dlg.open() == 0) {
            this.mapPage.addElement((NetworkMapElement)groupBox);
            this.saveMap();
        }
    }
}

