/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.log.LogColumn;

public class LogRecordDetails {
    private long id;
    private List<LogColumn> columns;
    private List<String> values;

    protected LogRecordDetails(long id, NXCPMessage msg) {
        this.id = id;
        int count2 = msg.getFieldAsInt32(166L);
        this.columns = new ArrayList<LogColumn>(count2);
        this.values = new ArrayList<String>(count2);
        long fieldIdMetadata = 0x10000000L;
        long fieldIdData = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.columns.add(new LogColumn(msg, fieldIdMetadata));
            this.values.add(msg.getFieldAsString(fieldIdData++));
            ++i;
            fieldIdMetadata += 10L;
        }
    }

    public long getId() {
        return this.id;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<LogColumn> getColumnDefinitions() {
        return this.columns;
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getValue(String columnName) {
        return this.values.get(this.getColumnIndex(columnName));
    }
}

