/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMemoryView$exposed___new__;
import org.python.core.PyMemoryView$format_descriptor;
import org.python.core.PyMemoryView$memoryview___enter___exposer;
import org.python.core.PyMemoryView$memoryview___exit___exposer;
import org.python.core.PyMemoryView$memoryview___hash___exposer;
import org.python.core.PyMemoryView$memoryview___lt___exposer;
import org.python.core.PyMemoryView$memoryview_release_exposer;
import org.python.core.PyMemoryView$memoryview_tolist_exposer;
import org.python.core.PyMemoryView$readonly_descriptor;
import org.python.core.PyMemoryView$strides_descriptor;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.buffer.BaseBuffer;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="memoryview", doc="memoryview(object)\n\nCreate a new memoryview object which references the given object.", base=PyObject.class, isBaseType=false)
public class PyMemoryView
extends PySequence
implements BufferProtocol,
Traverseproc {
    public static final PyType TYPE;
    private PyBuffer backing;
    private boolean released;
    private PyObject shape;
    private PyObject strides;
    private PyObject suboffsets;
    private int hashCache;
    private boolean hashCacheValid = false;
    private static final String cast_doc = "M.cast(format[, shape]) -> memoryview\n\nCast a memoryview to a new format or shape.";
    private static final String release_doc = "M.release() -> None\n\nRelease the underlying buffer exposed by the memoryview object.";
    private static final String tobytes_doc = "M.tobytes() -> bytes\n\nReturn the data in the buffer as a bytestring (an object of class str).";
    private static final String tolist_doc = "M.tolist() -> list\n\nReturn the data in the buffer as a list of elements.";
    private static final String c_contiguous_doc = "c_contiguous\nA bool indicating whether the memory is C contiguous.";
    private static final String contiguous_doc = "contiguous\nA bool indicating whether the memory is contiguous.";
    private static final String f_contiguous_doc = "c_contiguous\nA bool indicating whether the memory is Fortran contiguous.";
    private static final String format_doc = "format\nA string containing the format (in struct module style)\n for each element in the view.";
    private static final String itemsize_doc = "itemsize\nThe size in bytes of each element of the memoryview.";
    private static final String nbytes_doc = "nbytes\nThe amount of space in bytes that the array would use in\na contiguous representation.";
    private static final String ndim_doc = "ndim\nAn integer indicating how many dimensions of a multi-dimensional\narray the memory represents.";
    private static final String obj_doc = "obj\nThe underlying object of the memoryview.";
    private static final String readonly_doc = "readonly\nA bool indicating whether the memory is read only.";
    private static final String shape_doc = "shape\nA tuple of ndim integers giving the shape of the memory\nas an N-dimensional array.";
    private static final String strides_doc = "strides\nA tuple of ndim integers giving the size in bytes to access\neach element for each dimension of the array.";
    private static final String suboffsets_doc = "suboffsets\nA tuple of ndim integers used internally for PIL-style arrays\nor None.";

    public PyMemoryView(BufferProtocol pybuf) {
        super(TYPE);
        this.backing = pybuf.getBuffer(284);
    }

    @ExposedNew
    static PyObject memoryview_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length != 1) {
            throw Py.TypeError("memoryview() takes exactly one argument");
        }
        ArgParser ap = new ArgParser("memoryview", args, keywords, "object");
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof BufferProtocol) {
            return new PyMemoryView((BufferProtocol)((Object)obj));
        }
        throw Py.TypeError("cannot make memory view because object does not have the buffer interface");
    }

    public PyObject obj() {
        this.checkNotReleased();
        BufferProtocol obj = this.backing.getObj();
        return obj instanceof PyObject ? (PyObject)((Object)obj) : Py.None;
    }

    public String format() {
        this.checkNotReleased();
        return this.backing.getFormat();
    }

    public int itemsize() {
        this.checkNotReleased();
        return this.backing.getItemsize();
    }

    public PyObject shape() {
        this.checkNotReleased();
        if (this.shape == null) {
            this.shape = this.tupleOf(this.backing.getShape());
        }
        return this.shape;
    }

    public int ndim() {
        this.checkNotReleased();
        return this.backing.getNdim();
    }

    public PyObject strides() {
        this.checkNotReleased();
        if (this.strides == null) {
            this.strides = this.tupleOf(this.backing.getStrides());
        }
        return this.strides;
    }

    public PyObject suboffsets() {
        this.checkNotReleased();
        if (this.suboffsets == null) {
            this.suboffsets = this.tupleOf(this.backing.getSuboffsets());
        }
        return this.suboffsets;
    }

    public boolean readonly() {
        this.checkNotReleased();
        return this.backing.isReadonly();
    }

    public PyString tobytes() {
        return this.memoryview_tobytes();
    }

    final PyString memoryview_tobytes() {
        this.checkNotReleased();
        if (this.backing instanceof BaseBuffer) {
            return new PyString(this.backing.toString());
        }
        String s = StringUtil.fromBytes(this.backing);
        return new PyString(s);
    }

    public PyList tolist() {
        return this.memoryview_tolist();
    }

    final PyList memoryview_tolist() {
        this.checkNotReleased();
        int n = this.backing.getLen();
        PyList list = new PyList();
        for (int i = 0; i < n; ++i) {
            list.add(new PyInteger(this.backing.intAt(i)));
        }
        return list;
    }

    private PyObject tupleOf(int[] x) {
        if (x != null) {
            PyObject[] pyx = new PyLong[x.length];
            for (int k = 0; k < x.length; ++k) {
                pyx[k] = new PyLong(x[k]);
            }
            return new PyTuple(pyx, false);
        }
        return Py.None;
    }

    @Override
    public int __len__() {
        this.checkNotReleased();
        return this.backing.getLen();
    }

    @Override
    public int hashCode() {
        return this.memoryview___hash__();
    }

    final int memoryview___hash__() {
        if (!this.hashCacheValid) {
            this.checkNotReleased();
            if (this.backing.isReadonly()) {
                this.hashCache = this.backing.toString().hashCode();
                this.hashCacheValid = true;
            } else {
                throw Py.ValueError("cannot hash writable memoryview object");
            }
        }
        return this.hashCache;
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.memoryview___eq__(other);
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.memoryview___ne__(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.memoryview___lt__(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.memoryview___le__(other);
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.memoryview___ge__(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.memoryview___gt__(other);
    }

    private static int compare(PyBuffer a, PyBuffer b) {
        int ap = 0;
        int aEnd = ap + a.getLen();
        int bp = 0;
        int bEnd = b.getLen();
        while (ap < aEnd) {
            int bVal;
            int aVal;
            int diff;
            if (bp >= bEnd) {
                return 1;
            }
            if ((diff = (aVal = a.intAt(ap++)) - (bVal = b.intAt(bp++))) == 0) continue;
            return diff < 0 ? -1 : 1;
        }
        if (bp < bEnd) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int memoryview_cmp(PyObject b) {
        this.checkNotReleased();
        PyBuffer bv = BaseBytes.getView(b);
        if (bv == null) {
            return -2;
        }
        try {
            if (bv == this.backing) {
                int n = 0;
                return n;
            }
            int n = PyMemoryView.compare(this.backing, bv);
            return n;
        }
        finally {
            bv.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int memoryview_cmpeq(PyObject b) {
        if (this == b) {
            return 0;
        }
        if (this.released) {
            return -1;
        }
        if (b instanceof PyMemoryView && ((PyMemoryView)b).released) {
            return 1;
        }
        PyBuffer bv = BaseBytes.getView(b);
        if (bv == null) {
            return -2;
        }
        try {
            if (bv == this.backing) {
                int n = 0;
                return n;
            }
            if (bv.getLen() != this.backing.getLen()) {
                int n = 1;
                return n;
            }
            int n = PyMemoryView.compare(this.backing, bv);
            return n;
        }
        finally {
            bv.release();
        }
    }

    final PyObject memoryview___eq__(PyObject other) {
        int cmp = this.memoryview_cmpeq(other);
        if (cmp == 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject memoryview___ne__(PyObject other) {
        int cmp = this.memoryview_cmpeq(other);
        if (cmp == 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___lt__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp >= 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___le__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp > 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___ge__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp >= 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject memoryview___gt__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp > 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    public PyObject __enter__() {
        return this.memoryview___enter__();
    }

    final PyObject memoryview___enter__() {
        this.checkNotReleased();
        return this;
    }

    public boolean __exit__(PyObject type, PyObject value, PyObject traceback2) {
        return this.memoryview___exit__(type, value, traceback2);
    }

    final boolean memoryview___exit__(PyObject type, PyObject value, PyObject traceback2) {
        this.memoryview_release();
        return false;
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        this.checkNotReleased();
        return this.backing.getBuffer(flags);
    }

    public synchronized void release() {
        this.memoryview_release();
    }

    public final synchronized void memoryview_release() {
        if (!this.released) {
            this.backing.release();
            this.released = true;
        }
    }

    protected void checkNotReleased() {
        if (this.released) {
            throw Py.ValueError("operation forbidden on released memoryview object");
        }
        assert (!this.backing.isReleased());
    }

    @Override
    protected PyString pyget(int index) {
        this.checkNotReleased();
        return new PyString(String.valueOf((char)this.backing.intAt(index)));
    }

    @Override
    protected synchronized PyMemoryView getslice(int start, int stop, int step) {
        this.checkNotReleased();
        int n = PyMemoryView.sliceLength(start, stop, step);
        PyBuffer view = this.backing.getBufferSlice(284, start, n, step);
        PyMemoryView ret = new PyMemoryView(view);
        view.release();
        return ret;
    }

    @Override
    protected synchronized PyMemoryView repeat(int count2) throws PyException {
        throw Py.NotImplementedError("memoryview.repeat()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        this.checkNotReleased();
        PyBuffer valueBuf = BaseBytes.getViewOrError(value);
        try {
            if (valueBuf.getLen() != 1) {
                throw Py.ValueError("cannot modify size of memoryview object");
            }
            this.backing.storeAt(valueBuf.byteAt(0), index);
        }
        finally {
            valueBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void setslice(int start, int stop, int step, PyObject value) {
        this.checkNotReleased();
        if (step == 1 && stop < start) {
            stop = start;
        }
        PyBuffer valueBuf = BaseBytes.getViewOrError(value);
        PyBuffer backingSlice = null;
        try {
            int n = PyMemoryView.sliceLength(start, stop, step);
            if (n != valueBuf.getLen()) {
                throw Py.ValueError("cannot modify size of memoryview object");
            }
            backingSlice = this.backing.getBufferSlice(284, start, n, step);
            backingSlice.copyFrom(valueBuf);
        }
        finally {
            if (backingSlice != null) {
                backingSlice.release();
            }
            valueBuf.release();
        }
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.backing != null && (this.backing instanceof PyObject ? (retVal = visit.visit((PyObject)((Object)this.backing), arg)) != 0 : this.backing instanceof Traverseproc && (retVal = ((Traverseproc)((Object)this.backing)).traverse(visit, arg)) != 0)) {
            return retVal;
        }
        if (this.shape != null && (retVal = visit.visit(this.shape, arg)) != 0) {
            return retVal;
        }
        if (this.strides != null && (retVal = visit.visit(this.strides, arg)) != 0) {
            return retVal;
        }
        return this.suboffsets == null ? 0 : visit.visit(this.suboffsets, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        if (ob != null && (ob == this.backing || ob == this.shape || ob == this.strides || ob == this.suboffsets)) {
            return true;
        }
        if (this.suboffsets instanceof Traverseproc) {
            return ((Traverseproc)((Object)this.suboffsets)).refersDirectlyTo(ob);
        }
        return false;
    }

    static {
        PyType.addBuilder(PyMemoryView.class, new PyMemoryView$PyExposer());
        TYPE = PyType.fromClass(PyMemoryView.class);
    }

    public class PyMemoryView$memoryview_tobytes_exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview_tobytes_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "M.tobytes() -> bytes\n\nReturn the data in the buffer as a bytestring (an object of class str).";
        }

        public PyMemoryView$memoryview_tobytes_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "M.tobytes() -> bytes\n\nReturn the data in the buffer as a bytestring (an object of class str).";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview_tobytes_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyMemoryView)this.self).memoryview_tobytes();
        }
    }

    public class PyMemoryView$memoryview___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview___eq___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__eq__(y) <==> x==y";
        }

        public PyMemoryView$memoryview___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__eq__(y) <==> x==y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyMemoryView)this.self).memoryview___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyMemoryView$memoryview___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyMemoryView$memoryview___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyMemoryView)this.self).memoryview___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyMemoryView$memoryview___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview___le___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyMemoryView$memoryview___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyMemoryView)this.self).memoryview___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyMemoryView$memoryview___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview___ge___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyMemoryView$memoryview___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyMemoryView)this.self).memoryview___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyMemoryView$memoryview___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyMemoryView$memoryview___gt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyMemoryView$memoryview___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMemoryView$memoryview___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyMemoryView)this.self).memoryview___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyMemoryView$shape_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMemoryView$shape_descriptor() {
            super("shape", PyObject.class, "shape\nA tuple of ndim integers giving the shape of the memory\nas an N-dimensional array.");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMemoryView)pyObject).shape();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMemoryView$itemsize_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMemoryView$itemsize_descriptor() {
            super("itemsize", Integer.class, "itemsize\nThe size in bytes of each element of the memoryview.");
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PyMemoryView)pyObject).itemsize());
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMemoryView$ndim_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMemoryView$ndim_descriptor() {
            super("ndim", Integer.class, "ndim\nAn integer indicating how many dimensions of a multi-dimensional\narray the memory represents.");
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PyMemoryView)pyObject).ndim());
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMemoryView$suboffsets_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMemoryView$suboffsets_descriptor() {
            super("suboffsets", PyObject.class, "suboffsets\nA tuple of ndim integers used internally for PIL-style arrays\nor None.");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMemoryView)pyObject).suboffsets();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMemoryView$PyExposer
    extends BaseTypeBuilder {
        public PyMemoryView$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyMemoryView$memoryview_tobytes_exposer("tobytes"), new PyMemoryView$memoryview_tolist_exposer("tolist"), new PyMemoryView$memoryview___hash___exposer("__hash__"), new PyMemoryView$memoryview___eq___exposer("__eq__"), new PyMemoryView$memoryview___ne___exposer("__ne__"), new PyMemoryView$memoryview___lt___exposer("__lt__"), new PyMemoryView$memoryview___le___exposer("__le__"), new PyMemoryView$memoryview___ge___exposer("__ge__"), new PyMemoryView$memoryview___gt___exposer("__gt__"), new PyMemoryView$memoryview___enter___exposer("__enter__"), new PyMemoryView$memoryview___exit___exposer("__exit__"), new PyMemoryView$memoryview_release_exposer("release")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyMemoryView$shape_descriptor(), new PyMemoryView$readonly_descriptor(), new PyMemoryView$format_descriptor(), new PyMemoryView$itemsize_descriptor(), new PyMemoryView$ndim_descriptor(), new PyMemoryView$strides_descriptor(), new PyMemoryView$suboffsets_descriptor()};
            super("memoryview", PyMemoryView.class, PyObject.class, false, "memoryview(object)\n\nCreate a new memoryview object which references the given object.", pyBuiltinMethodArray, pyDataDescrArray, new PyMemoryView$exposed___new__());
        }
    }
}

