/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.combinations$combinations___init___exposer;
import org.python.modules.itertools.combinations$exposed___new__;
import org.python.modules.itertools.combinations$next_exposer;
import org.python.modules.itertools.itertools;

@ExposedType(name="itertools.combinations", base=PyObject.class, doc="combinations(iterable, r) --> combinations object\n\nReturn successive r-length combinations of elements in the iterable.\n\ncombinations(range(4), 3) --> (0,1,2), (0,1,3), (0,2,3), (1,2,3)")
public class combinations
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String combinations_doc = "combinations(iterable, r) --> combinations object\n\nReturn successive r-length combinations of elements in the iterable.\n\ncombinations(range(4), 3) --> (0,1,2), (0,1,3), (0,2,3), (1,2,3)";

    public combinations() {
    }

    public combinations(PyType subType) {
        super(subType);
    }

    public combinations(PyObject iterable, int r) {
        this.combinations___init__(iterable, r);
    }

    @ExposedNew
    final void combinations___init__(PyObject[] args, String[] kwds) {
        if (args.length > 2) {
            throw Py.TypeError(String.format("combinations_with_replacement() takes at most 2 arguments (%d given)", args.length));
        }
        ArgParser ap = new ArgParser("combinations_with_replacement", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        int r = ap.getInt(1);
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        this.combinations___init__(iterable, r);
    }

    private void combinations___init__(PyObject iterable, final int r) {
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        final PyTuple pool = PyTuple.fromIterable(iterable);
        final int n = pool.__len__();
        final int[] indices = new int[r];
        for (int i = 0; i < r; ++i) {
            indices[i] = i;
        }
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                int i;
                if (r > n) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(pool, indices);
                }
                for (i = r - 1; i >= 0 && indices[i] == i + n - r; --i) {
                }
                if (i < 0) {
                    return null;
                }
                int n2 = i;
                indices[n2] = indices[n2] + 1;
                for (int j = i + 1; j < r; ++j) {
                    indices[j] = indices[j - 1] + 1;
                }
                return itertools.makeIndexedTuple(pool, indices);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(combinations.class, new combinations$PyExposer());
        TYPE = PyType.fromClass(combinations.class);
    }

    public class combinations$PyExposer
    extends BaseTypeBuilder {
        public combinations$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new combinations$combinations___init___exposer("__init__"), new combinations$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.combinations", combinations.class, PyObject.class, true, "combinations(iterable, r) --> combinations object\n\nReturn successive r-length combinations of elements in the iterable.\n\ncombinations(range(4), 3) --> (0,1,2), (0,1,3), (0,2,3), (1,2,3)", pyBuiltinMethodArray, pyDataDescrArray, new combinations$exposed___new__());
        }
    }
}

