/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import com.bea.xml.stream.ConfigurationContextBase;
import com.bea.xml.stream.EventReaderFilter;
import com.bea.xml.stream.MXParser;
import com.bea.xml.stream.StreamReaderFilter;
import com.bea.xml.stream.XMLEventReaderBase;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public class MXParserFactory
extends XMLInputFactory {
    ConfigurationContextBase config = new ConfigurationContextBase();

    public static XMLInputFactory newInstance() {
        return XMLInputFactory.newInstance();
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        if (source instanceof SAXSource) {
            SAXSource ss = (SAXSource)source;
            InputSource isource = ss.getInputSource();
            if (isource != null) {
                String sysId = isource.getSystemId();
                Reader r = isource.getCharacterStream();
                if (r != null) {
                    return this.createXMLStreamReader(sysId, r);
                }
                InputStream in = isource.getByteStream();
                if (in != null) {
                    return this.createXMLStreamReader(sysId, in);
                }
            }
            throw new XMLStreamException("Can only create STaX reader for a SAXSource if Reader or InputStream exposed via getSource(); can not use -- not implemented.");
        }
        if (source instanceof DOMSource) {
            // empty if block
        }
        throw new UnsupportedOperationException("XMLInputFactory.createXMLStreamReader(" + source.getClass().getName() + ") not yet implemented");
    }

    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        MXParser pp = new MXParser();
        pp.setInput(stream);
        pp.setConfigurationContext(this.config);
        return pp;
    }

    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        MXParser pp = new MXParser();
        pp.setInput(stream, encoding);
        pp.setConfigurationContext(this.config);
        return pp;
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLStreamReader(stream);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(reader);
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(reader);
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(stream);
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(reader));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        XMLEventReaderBase base2 = this.config.getEventAllocator() == null ? new XMLEventReaderBase(reader) : new XMLEventReaderBase(reader, this.config.getEventAllocator().newInstance());
        return base2;
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(source));
    }

    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream));
    }

    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream, encoding));
    }

    public XMLResolver getXMLResolver() {
        return this.config.getXMLResolver();
    }

    public void setXMLResolver(XMLResolver resolver) {
        this.config.setXMLResolver(resolver);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new StreamReaderFilter(reader, filter);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new EventReaderFilter(reader, filter);
    }

    public XMLReporter getXMLReporter() {
        return this.config.getXMLReporter();
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.config.setXMLReporter(reporter);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.config.setEventAllocator(allocator);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.config.getEventAllocator();
    }

    public void setCoalescing(boolean coalescing) {
        this.config.setCoalescing(coalescing);
    }

    public boolean isCoalescing() {
        return this.config.isCoalescing();
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this.config.setProperty(name, value);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.config.getProperty(name);
    }

    public XMLStreamReader createXMLStreamReader(Reader in) throws XMLStreamException {
        MXParser pp = new MXParser();
        pp.setInput(in);
        pp.setConfigurationContext(this.config);
        return pp;
    }

    public boolean isPropertySupported(String name) {
        return this.config.isPropertySupported(name);
    }
}

