/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.NCConfigurationTemplate;

public class NotificationChannel {
    private String name;
    private String description;
    private String driverName;
    private String configuration;
    private boolean isActive;
    private NCConfigurationTemplate configurationTemplate;
    private String errorMessage;
    private int lastStatus;

    protected NotificationChannel(NXCPMessage msg, long base2) {
        this.name = msg.getFieldAsString(base2);
        this.description = msg.getFieldAsString(base2 + 1L);
        this.driverName = msg.getFieldAsString(base2 + 2L);
        this.configuration = msg.getFieldAsString(base2 + 3L);
        this.isActive = msg.getFieldAsBoolean(base2 + 4L);
        this.configurationTemplate = new NCConfigurationTemplate(msg, base2 + 5L);
        this.errorMessage = msg.getFieldAsString(base2 + 7L);
        this.lastStatus = msg.getFieldAsInt32(base2 + 8L);
    }

    public NotificationChannel() {
        this.name = "";
        this.description = "";
        this.driverName = null;
        this.configuration = "";
        this.isActive = false;
        this.configurationTemplate = null;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setField(380L, this.driverName);
        msg.setField(584L, this.configuration);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public NCConfigurationTemplate getConfigurationTemplate() {
        return this.configurationTemplate;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public String getLastStatusAsString() {
        return this.lastStatus == 0 ? "Unknown" : (this.lastStatus == 1 ? "Success" : "Error");
    }
}

