/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyFrozenSet;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.modules.SHA224Digest;

public class _hashlib
implements ClassDictInit {
    private static final Map<String, String> algorithmMap = new HashMap<String, String>(){
        {
            this.put("sha1", "sha-1");
            this.put("sha224", "sha-224");
            this.put("sha256", "sha-256");
            this.put("sha384", "sha-384");
            this.put("sha512", "sha-512");
        }
    };
    public static final PyFrozenSet openssl_md_meth_names = new PyFrozenSet(new PyTuple(Py.newString("md5"), Py.newString("sha1"), Py.newString("sha224"), Py.newString("sha256"), Py.newString("sha384"), Py.newString("sha512")));

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__name__", (PyObject)Py.newString("_hashlib"));
        dict.__setitem__("algorithmMap", null);
        dict.__setitem__("classDictInit", null);
    }

    public static PyObject new$(String name) {
        return _hashlib.new$(name, null);
    }

    public static PyObject new$(String name, PyObject obj) {
        if (algorithmMap.containsKey(name = name.toLowerCase())) {
            name = algorithmMap.get(name);
        }
        Hash hash = new Hash(name);
        if (obj != null) {
            hash.update(obj);
        }
        return hash;
    }

    public static PyObject openssl_md5() {
        return _hashlib.openssl_md5(null);
    }

    public static PyObject openssl_md5(PyObject obj) {
        return _hashlib.new$("md5", obj);
    }

    public static PyObject openssl_sha1() {
        return _hashlib.openssl_sha1(null);
    }

    public static PyObject openssl_sha1(PyObject obj) {
        return _hashlib.new$("sha1", obj);
    }

    public static PyObject openssl_sha224() {
        return _hashlib.openssl_sha224(null);
    }

    public static PyObject openssl_sha224(PyObject obj) {
        return _hashlib.new$("sha224", obj);
    }

    public static PyObject openssl_sha256() {
        return _hashlib.openssl_sha256(null);
    }

    public static PyObject openssl_sha256(PyObject obj) {
        return _hashlib.new$("sha256", obj);
    }

    public static PyObject openssl_sha384() {
        return _hashlib.openssl_sha384(null);
    }

    public static PyObject openssl_sha384(PyObject obj) {
        return _hashlib.new$("sha384", obj);
    }

    public static PyObject openssl_sha512() {
        return _hashlib.openssl_sha512(null);
    }

    public static PyObject openssl_sha512(PyObject obj) {
        return _hashlib.new$("sha512", obj);
    }

    @Untraversable
    @ExposedType(name="_hashlib.HASH")
    public static class Hash
    extends PyObject {
        public static final PyType TYPE;
        public String name;
        private MessageDigest digest;
        private static final Map<String, Integer> blockSizes;

        public Hash(String name) {
            this(name, Hash.getDigest(name));
        }

        private Hash(String name, MessageDigest digest) {
            super(TYPE);
            this.name = name;
            this.digest = digest;
        }

        private static final MessageDigest getDigest(String name) {
            try {
                if (name.equals("sha-224")) {
                    return new SHA224Digest();
                }
                return MessageDigest.getInstance(name);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw Py.ValueError("unsupported hash type");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageDigest cloneDigest() {
            try {
                Hash hash = this;
                synchronized (hash) {
                    return (MessageDigest)this.digest.clone();
                }
            }
            catch (CloneNotSupportedException cnse) {
                throw Py.RuntimeError(String.format("_hashlib.HASH (%s) internal error", this.name));
            }
        }

        private byte[] calculateDigest() {
            return this.cloneDigest().digest();
        }

        public void update(PyObject obj) {
            this.HASH_update(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void HASH_update(PyObject obj) {
            String string2;
            if (obj instanceof PyUnicode) {
                string2 = ((PyUnicode)obj).encode();
            } else if (obj instanceof PyString) {
                string2 = obj.toString();
            } else if (obj instanceof PyArray) {
                string2 = ((PyArray)obj).tostring();
            } else {
                throw Py.TypeError("update() argument 1 must be string or read-only buffer, not " + obj.getType().fastGetName());
            }
            byte[] input = StringUtil.toBytes(string2);
            Hash hash = this;
            synchronized (hash) {
                this.digest.update(input);
            }
        }

        public PyObject digest() {
            return this.HASH_digest();
        }

        final PyObject HASH_digest() {
            return Py.newString(StringUtil.fromBytes(this.calculateDigest()));
        }

        public PyObject hexdigest() {
            return this.HASH_hexdigest();
        }

        final PyObject HASH_hexdigest() {
            byte[] result2 = this.calculateDigest();
            char[] hexDigest = new char[result2.length * 2];
            int j = 0;
            for (int i = 0; i < result2.length; ++i) {
                int c = result2[i] >> 4 & 0xF;
                c = c > 9 ? c + 97 - 10 : c + 48;
                hexDigest[j++] = (char)c;
                c = result2[i] & 0xF;
                c = c > 9 ? c + 97 - 10 : c + 48;
                hexDigest[j++] = (char)c;
            }
            return Py.newString(new String(hexDigest));
        }

        public PyObject copy() {
            return this.HASH_copy();
        }

        final PyObject HASH_copy() {
            return new Hash(this.name, this.cloneDigest());
        }

        public synchronized int getDigestSize() {
            return this.digest.getDigestLength();
        }

        public int getDigest_size() {
            return this.getDigestSize();
        }

        public PyObject getBlockSize() {
            Integer size = blockSizes.get(this.name);
            if (size == null) {
                return Py.None;
            }
            return Py.newInteger(size);
        }

        @Override
        public String toString() {
            return String.format("<%s HASH object @ %s>", this.name, Py.idstr(this));
        }

        static {
            PyType.addBuilder(Hash.class, new _hashlib$Hash$PyExposer());
            TYPE = PyType.fromClass(Hash.class);
            blockSizes = new HashMap<String, Integer>(){
                {
                    this.put("md5", 64);
                    this.put("sha-1", 64);
                    this.put("sha-224", 64);
                    this.put("sha-256", 64);
                    this.put("sha-384", 128);
                    this.put("sha-512", 128);
                }
            };
        }

        public class _hashlib$Hash$HASH_update_exposer
        extends PyBuiltinMethodNarrow {
            public _hashlib$Hash$HASH_update_exposer(String string2) {
                super(string2, 2, 2);
                this.doc = "";
            }

            public _hashlib$Hash$HASH_update_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new _hashlib$Hash$HASH_update_exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((Hash)this.self).HASH_update(pyObject);
                return Py.None;
            }
        }

        public class _hashlib$Hash$HASH_digest_exposer
        extends PyBuiltinMethodNarrow {
            public _hashlib$Hash$HASH_digest_exposer(String string2) {
                super(string2, 1, 1);
                this.doc = "";
            }

            public _hashlib$Hash$HASH_digest_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new _hashlib$Hash$HASH_digest_exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__() {
                return ((Hash)this.self).HASH_digest();
            }
        }

        public class _hashlib$Hash$HASH_hexdigest_exposer
        extends PyBuiltinMethodNarrow {
            public _hashlib$Hash$HASH_hexdigest_exposer(String string2) {
                super(string2, 1, 1);
                this.doc = "";
            }

            public _hashlib$Hash$HASH_hexdigest_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new _hashlib$Hash$HASH_hexdigest_exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__() {
                return ((Hash)this.self).HASH_hexdigest();
            }
        }

        public class _hashlib$Hash$HASH_copy_exposer
        extends PyBuiltinMethodNarrow {
            public _hashlib$Hash$HASH_copy_exposer(String string2) {
                super(string2, 1, 1);
                this.doc = "";
            }

            public _hashlib$Hash$HASH_copy_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new _hashlib$Hash$HASH_copy_exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__() {
                return ((Hash)this.self).HASH_copy();
            }
        }

        public class _hashlib$Hash$digestsize_descriptor
        extends PyDataDescr
        implements ExposeAsSuperclass {
            public _hashlib$Hash$digestsize_descriptor() {
                super("digestsize", Integer.class, null);
            }

            public Object invokeGet(PyObject pyObject) {
                return Py.newInteger(((Hash)pyObject).getDigestSize());
            }

            public boolean implementsDescrGet() {
                return true;
            }

            public boolean implementsDescrSet() {
                return false;
            }

            public boolean implementsDescrDelete() {
                return false;
            }
        }

        public class _hashlib$Hash$name_descriptor
        extends PyDataDescr
        implements ExposeAsSuperclass {
            public _hashlib$Hash$name_descriptor() {
                super("name", String.class, null);
            }

            public Object invokeGet(PyObject pyObject) {
                String string2 = ((Hash)pyObject).name;
                return string2 == null ? Py.None : Py.newString(string2);
            }

            public boolean implementsDescrGet() {
                return true;
            }

            public boolean implementsDescrSet() {
                return false;
            }

            public boolean implementsDescrDelete() {
                return false;
            }
        }

        public class _hashlib$Hash$block_size_descriptor
        extends PyDataDescr
        implements ExposeAsSuperclass {
            public _hashlib$Hash$block_size_descriptor() {
                super("block_size", PyObject.class, null);
            }

            public Object invokeGet(PyObject pyObject) {
                return ((Hash)pyObject).getBlockSize();
            }

            public boolean implementsDescrGet() {
                return true;
            }

            public boolean implementsDescrSet() {
                return false;
            }

            public boolean implementsDescrDelete() {
                return false;
            }
        }

        public class _hashlib$Hash$digest_size_descriptor
        extends PyDataDescr
        implements ExposeAsSuperclass {
            public _hashlib$Hash$digest_size_descriptor() {
                super("digest_size", Integer.class, null);
            }

            public Object invokeGet(PyObject pyObject) {
                return Py.newInteger(((Hash)pyObject).getDigest_size());
            }

            public boolean implementsDescrGet() {
                return true;
            }

            public boolean implementsDescrSet() {
                return false;
            }

            public boolean implementsDescrDelete() {
                return false;
            }
        }

        public class _hashlib$Hash$PyExposer
        extends BaseTypeBuilder {
            public _hashlib$Hash$PyExposer() {
                PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new _hashlib$Hash$HASH_update_exposer("update"), new _hashlib$Hash$HASH_digest_exposer("digest"), new _hashlib$Hash$HASH_hexdigest_exposer("hexdigest"), new _hashlib$Hash$HASH_copy_exposer("copy")};
                PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new _hashlib$Hash$digestsize_descriptor(), new _hashlib$Hash$name_descriptor(), new _hashlib$Hash$block_size_descriptor(), new _hashlib$Hash$digest_size_descriptor()};
                super("_hashlib.HASH", Hash.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, null);
            }
        }
    }
}

